//
//  GrMain.h
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/19.
//
//

#ifndef __myNewApp__GrMain__
#define __myNewApp__GrMain__

#include "ofMain.h"

class GrBase;
class GrDrawer;
class GrUpdater;
class GrTouch;
class GrGrab;
class GrMouse;

//--------------------------------------------------------------
class GrMain {
private:
    std::vector<ofPtr<GrBase> > mGrBase;
    std::vector<GrUpdater*> mGrUpdates;
    std::vector<GrDrawer*> mGrDraws;
    std::vector<GrMouse*> mGrMouses;
    std::vector<GrBase*> mPreAddMember;
	
    void addMemberImpl(GrBase *grBase);
    ofMutex mPreAddLock;

public:
    GrMain();

	/* -- Updater -- */
    void update();
	
	/* -- Drawer -- */
    void draw();
	
	/* -- Mouse -- */
	void mouseMoved(int x, int y );
	void mouseDragged(int x, int y, int button);
	void mousePressed(int x, int y, int button);
	void mouseReleased(int x, int y, int button);

    void add(GrBase *grBase);
};

#endif /* defined(__myNewApp__GrMain__) */
