/*
 * Positionable.h
 *
 *  Created on: 2009/02/17
 *      Author: ox
 */

#ifndef POSITIONABLE_H_
#define POSITIONABLE_H_

#include "PositionPort.h"
#include "graphic/DeadNotifier.h"

class Positionable : public DeadNotifier {
public:
	Positionable(float posx = 0.5, float posy = 0.5, float posz = 0.5);
	virtual ~Positionable();

	void *setPos(Positionable *positionable);

	void setPos(float posx, float posy, float z = 0.5);

	//! setter
	void setX(float posx);
	void setY(float posy);
	void setZ(float posz);

	//! getter
	float getX();
	float getY();
	float getZ();

	//! get port
	XPort *newXPort();
	YPort *newYPort();
	ZPort *newZPort();

	//! getter(Pixel Value)
	float getPixelX();
	float getPixelY();
	float getPixelZ();

	float distance(Positionable *p);

protected:
	/*!
	 * Pixel Value
	 */
	float pixelX, pixelY, pixelZ;

private:
	/*!
	 * Normalized(0~1) Value
	 */
	float nx, ny, nz;
};

#endif /* POSITIONABLE_H_ */
