/*
 * Positionable.cpp
 *
 *  Created on: 2009/02/17
 *      Author: ox
 */

#include "Positionable.h"
#include "PositionPort.h"
#include "graphic/GLFWMain.h"

Positionable::Positionable(float posx, float posy, float posz)
{
	setPos(posx, posy, posz);
}

Positionable::~Positionable() {
}

/*!
 *	\brief positionablẽp[^Rs[
 */
void *Positionable::setPos(Positionable *positionable)
{
	setPos(positionable->getX(), positionable->getY(), positionable->getZ());
	return this;
}

/*!
 * \brief ʒu͉ʍ̑Έʒu0~1̐KꂽlŎw肷
 */
void Positionable::setPos(float posx, float posy, float posz)
{
	setX(posx);
	setY(posy);
	setZ(posz);
}

/*!
 * setter
 */
void Positionable::setX(float posx)
{
	float fw = GLFWMain::getInstance()->width;
	this->nx = posx;
	this->pixelX = fw * (posx - 0.5);
}

void Positionable::setY(float posy)
{
	float fh = GLFWMain::getInstance()->height;
	this->ny = posy;
	this->pixelY = fh * (0.5 - posy);
}

void Positionable::setZ(float posz)
{
	float fw = GLFWMain::getInstance()->width;
	this->nz = posz;
	this->pixelZ = fw * (posz - 0.5);
}

/*!
 * getter
 */
float Positionable::getX()
{
	return nx;
}

float Positionable::getY()
{
	return ny;
}

float Positionable::getZ()
{
	return nz;
}

/*!
 * getter
 */
float Positionable::getPixelX()
{
	return pixelX;
}

float Positionable::getPixelY()
{
	return pixelY;
}

float Positionable::getPixelZ()
{
	return pixelZ;
}

/*!
 * new Port
 */
XPort *Positionable::newXPort()
{
	return new XPort(this);
}
YPort *Positionable::newYPort()
{
	return new YPort(this);
}
ZPort *Positionable::newZPort()
{
	return new ZPort(this);
}

/*!
 *
 */
float Positionable::distance(Positionable *p)
{
	float dx = nx - p->nx;
	float dy = ny - p->ny;
	float dz = nz - p->nz;
	return sqrt(dz*dz + sqrt(dx*dx + dy*dy));
}
