#include "testApp.h"
#include "GrDrawer.h"
#include "testCodePool.h"

#include "GrPoint.h"

testApp::testApp() :
    sampleRate(44100),
    initialBufferSize(1024),
    bufferLch(new float[initialBufferSize]),
    bufferRch(new float[initialBufferSize]),
    am(initialBufferSize)
{
    // Test Routine
    //  testSharedPointer();
    
    // check grDraw
    //    ofPtr<GrBase> grPtr = ofPtr<GrBase>(grBase);
    //    ofPtr<GrDrawer> drawPtr = grPtr;
}

void testApp::audioOut(float *output, int size, int channels)
{
    am.audioOut(output, size, channels);
    for (int i = 0; i < size; i++) {
        bufferLch[i] = output[i * 2];
        bufferRch[i] = output[i * 2 + 1];
    }
}

//--------------------------------------------------------------
void testApp::setup()
{
    // of Logging Level
    ofSetLogLevel(OF_LOG_VERBOSE);
    
	// register touch events
	//ofRegisterTouchEvents(this);
	
	// initialize the accelerometer
	//ofxAccelerometer.setup();
	
	//iPhoneAlerts will be sent to this.
	//ofxiPhoneAlerts.addListener(this);
	
	//If you want a landscape oreintation 
	//ofxiPhoneSetOrientation(OFXIPHONE_ORIENTATION_LANDSCAPE_RIGHT);
    
	ofBackground(255,255,255);
    
    // audio setup
    ofSoundStreamSetup(2, 0, this, 44100, initialBufferSize, 4);
    
    ofSetFrameRate(60);
}

//--------------------------------------------------------------
void testApp::update()
{
    gm.update();
}

//--------------------------------------------------------------
void testApp::draw()
{
    gm.draw();
#if 0
    
	float boxW		= 200.0;
	float boxH		= boxW*0.75;
	
	float topY		= 30;
	float leftX		= 30;
	float rightX	= leftX + boxW + 20;
    
	// draw the left:
	ofSetHexColor(0x333333);
	ofRect(leftX, topY, boxW, boxH);
	ofSetHexColor(0xFFFFFF);
	for (int i = 0; i < initialBufferSize; i++){
		float x = ofMap(i, 0, initialBufferSize, 0, boxW, true);
		ofLine(leftX+x, topY + boxH/2, leftX+x, topY + boxH/2 + bufferLch[i] * boxH * 0.5);
	}
    
	// draw the right:
	ofSetHexColor(0x333333);
	ofRect(rightX, topY, boxW, boxH);
	ofSetHexColor(0xFFFFFF);
	for (int i = 0; i < initialBufferSize; i++){
		float x = ofMap(i, 0, initialBufferSize, 0, boxW, true);
		ofLine(rightX + x, topY + boxH/2, rightX + x, topY + boxH/2 + bufferRch[i] * boxH * 0.5);
	}
    
	ofSetHexColor(0x333333);
	char reportString[255];
	sprintf(reportString, "volume: (%f) \npan: (%f)\nsynthesis: %s", am.volume(), am.pan(), "sine wave");
//	sprintf(reportString, "%s (%fhz)", reportString, targetFrequency);
    
	ofDrawBitmapString(reportString,leftX,topY + boxH + 20);
#endif
}

void testApp::exit()
{

}

//--------------------------------------------------------------
void testApp::keyPressed  (int key)
{

}

//--------------------------------------------------------------
void testApp::keyReleased  (int key)
{

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y )
{

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button)
{

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button)
{
	gm.add(new GrPoint(x, y));
}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button)
{

}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg)
{

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo)
{ 

}

void testApp::windowResized(int w, int h)
{
	
}


