/*
 * Resizable.cpp
 *
 *  Created on: 2009/03/07
 *      Author: ox
 */

#include "Resizable.h"
#include "graphic/GLFWMain.h"

Resizable::Resizable(float size)
{
	setSize(size);
}

Resizable::~Resizable() {
}

/*!
 *	\brief resizẽp[^Rs[
 *	\param resize
 */
void *Resizable::setSize(Resizable *resize)
{
	setSize(resize->getSize());
	return this;
}

/*!
 * \brief TCY͉Height1Ƃ0~1̐KꂽlŎw肷
 */
void Resizable::setSize(float s)
{
	this->nsize = s;
	this->sizePixel = nsize * GLFWMain::getInstance()->height;
	this->pixelSizeH = sizePixel * 0.5;
	setWidth(s);
	setHeight(s);
}

/*!
 * \brief Height1Ƃ0~1̐KꂽlŎ擾
 */
float Resizable::getSize()
{
	return nsize;
}

/*!
 * \brief PixellŎ擾
 */
float Resizable::getSizePixel()
{
	return sizePixel;
}

/*!
 * \brief TCỸ|[g쐬
 */
SizePort *Resizable::getSizePort()
{
	return new SizePort(this);
}

/*!
 * \brief `̕擾i0~1̐Klj
 */
float Resizable::getWidth()
{
	return width;
}

/*!
 * \brief `̕擾iPixellj
 */
float Resizable::getWidthPixel()
{
	return widthPixel;
}

/*!
 * \brief `̕w肷i0~1̐Klj
 */
void Resizable::setWidth(float width)
{
	this->width = width;
	this->widthPixel = width * GLFWMain::getInstance()->width;
}

/*!
 * \brief Width̃|[g쐬
 */
WidthPort *Resizable::getWidthPort()
{
	return new WidthPort(this);
}

/*!
 * \brief `̍擾i0~1̐Klj
 */
float Resizable::getHeight()
{
	return height;
}

/*!
 * \brief `̍擾iPixellj
 */
float Resizable::getHeightPixel()
{
	return heightPixel;
}

void Resizable::setHeight(float height)
{
	this->height = height;
	this->heightPixel = height * GLFWMain::getInstance()->height;
}

/*!
 * \brief Height̃|[g쐬
 */
HeightPort *Resizable::getHeightPort()
{
	return new HeightPort(this);
}

