//
//  GrMain.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/19.
//
//

#include <vector>
#include <stdio.h>
#include "GrMain.h"
#include "GrDrawer.h"
#include "GrUpdater.h"
#include "GrPoint.h"
#include "GrGrab.h"

GrMain::GrMain()
{
    ofLogToConsole();
}

#pragma mark -- Loop Proc --
void GrMain::update()
{
    // add preAdd Member
    mPreAddLock.lock();
    for(std::vector<GrBase*>::iterator itr = mPreAddMember.begin(); itr != mPreAddMember.end(); itr++)
    {
        addMemberImpl((GrBase*)*itr);
    }
    mPreAddMember.clear();
    mPreAddLock.unlock();

    // update GrUpdater
    for(std::vector<ofPtr<GrUpdater> >::iterator itr = mGrUpdates.begin(); itr != mGrUpdates.end(); itr++)
    {
        ((ofPtr<GrUpdater>)*itr)->update();
    }
}

void GrMain::draw()
{
    // draw GrDrawer
    for(std::vector<ofPtr<GrDrawer> >::iterator itr = mGrDraws.begin(); itr != mGrDraws.end(); itr++)
    {
        ((ofPtr<GrDrawer>)*itr)->draw();
    }
}

// add member routine
void GrMain::add(GrBase *grBase)
{
    mPreAddLock.lock();
    mPreAddMember.push_back(grBase);
    mPreAddLock.unlock();
}

# pragma mark --- private method ---
void GrMain::addMemberImpl(GrBase *grBase)
{
    // Add Member Drawer
    GrDrawer *drawer = dynamic_cast<GrDrawer*>(grBase);
    if(NULL != drawer)
    {
        mGrDraws.push_back(ofPtr<GrDrawer>(drawer));
    }
    
    // Add Member Updater
    GrUpdater *updater = dynamic_cast<GrUpdater*>(grBase);
    if(NULL != updater)
    {
        mGrUpdates.push_back(ofPtr<GrUpdater>(updater));
    }
}

inline void ofLoggingTouchEvent(char *name, ofTouchEventArgs &touch)
{
    ofLog(OF_LOG_ERROR, "%s,%d,%d,%f,%f,%d", name, touch.id, touch.time, touch.x, touch.y, touch.numTouches);
}
