/*
 * DeadNotifier.h
 *
 *  Created on: 2009/03/12
 *      Author: ox
 */

#ifndef DEADNOTIFIER_H_
#define DEADNOTIFIER_H_

#include "common.h"
#include "DeadListener.h"

/*!
 * DeadListenerを保持するクラスが継承する
 * デストラクタ呼び出しでDeadListenerにdeadNotify通知を行う
 */
class DeadNotifier {
public:
	DeadNotifier();
	virtual ~DeadNotifier();
    
	/*!
	 * Dead通知を受け取るListener
	 */
	void addDeadListener(DeadListener *deadListener);
	void removeDeadListener(DeadListener *deadListener);
    
private:
	vector<DeadListener*> deadListeners;
};

#endif /* DEADNOTIFIER_H_ */
