#include <stdio.h>
#include <limits.h>

#include <Stk.h>

#include "SimDelay.h"
#include "SimInst.h"

#define SAMPLING_RATE 48000
#define FRAME_LEN     320

using namespace stk;

void test()
{
	static FILE *fhOutPcm;
	static unsigned int counter = 0;
	static unsigned int simSec = 5;
	//static SimDelay sim_delay;
	static SimInst sim_inst;
	
	if((fhOutPcm = fopen("out.pcm", "wb")) == NULL) {
		fprintf(stderr, "file open error.");
	}

	Stk::setSampleRate(SAMPLING_RATE);

	while(counter++ < SAMPLING_RATE * simSec) {
		//StkFloat lastSample = sim_delay.tick();
		StkFloat lastSample = sim_inst.tick();
		short lastShort = (short)(lastSample * SHRT_MAX);
		fwrite(&lastShort, sizeof(short), 1, fhOutPcm);
	}
}

int main (int argc, char *argv[])
{
	stk::Stk::setRawwavePath("../stk-4.4.3/rawwaves/");
	stk::Stk::setSampleRate(SAMPLING_RATE);
	
	test();
}
