#ifndef DSP_OSCILLATOR
#define DSP_OSCILLATOR

#define TABLE_SIZE_DEFAULT 2048

class Oscillator {
public:
	Oscillator(int tableSize = TABLE_SIZE_DEFAULT);
	float UpdateWithoutInterpolation(float frequency);
	float UpdateWithLinearInterpolation(float frequency);
	float UpdateWithCubicInterpolation( float frequency );

private:
	float phase;
	float sampleRate;
	int TableSize;
	
	float *table, *dtable0, *dtable1, *dtable2, *dtable3;

	void initTable();
};

#endif // DSP_OSCILLATOR
