#include "BlitSaw.h"

using namespace stk;

#define TEST_AU_001_OUT_PCM "au_test_out_001.pcm"
#define TEST_AU_001_OUT_SAMPLES 10000
#define PCM_VAL_MAX 32767
#define PCM_VAL_MIN -32768

inline short double2short(double in) {
	if(in > 1) {
		return PCM_VAL_MAX;
	} else if(in < -1) {
		return PCM_VAL_MIN;
	} else {
		return in * PCM_VAL_MAX;
	}
}

void test_au_001()
{
	BlitSaw saw(200);

	FILE *fpOut;

	if((fpOut = fopen(TEST_AU_001_OUT_PCM, "wb")) == NULL) {
		printf("file open error : %s\n", TEST_AU_001_OUT_PCM);
		return;
	}

	for(int i = 0; i < TEST_AU_001_OUT_SAMPLES; i++) {
		double v = saw.tick();
		short s = double2short(v);
		fwrite(&s, sizeof(short), 1, fpOut);
	}

	fclose(fpOut);
}

void test_au_002()
{
	
}
