#include "PSig.h"
#include "PSigMacro.h"

namespace psig {

/* ----------------------------------------------------------------------------
 * PDrawStyle 
 * ----------------------------------------------------------------------------*/
class PDrawStyle {
public:
	virtual void drawStyle() = 0;
};

/**
 * @brief PPos class
 * @description 
 * @note 
 */
class PPos : public PDrawStyle {
public:
	PGenConstructor2Arg(PPos, x, y);

	void drawStyle() {
		ofTranslate(x.get(), y.get());
	}
	PPort x, y;
};

/**
 * @brief PRot class
 * @description 
 * @note 
 */
class PRot : public PDrawStyle {
public:
	PGenConstructor3Arg(PRot, x, y, z);

	void drawStyle() {
		printf("%f\n", z.get());
		ofRotate(100, x.get(), y.get(), z.get());
	}
	PPort x, y, z;
};

/**
 * @brief PRotX class
 * @description 
 * @note 
 */
class PRotX : public PDrawStyle {
public:
	PGenConstructor1Arg(PRotX, x)
	
	void drawStyle() {
		ofRotateX(x.get());
	}
	PPort x;
};

/**
 * @brief PRotY class
 * @description 
 * @note 
 */
class PRotY : public PDrawStyle {
public:
	PGenConstructor1Arg(PRotY, y)
	
	void drawStyle() {
		ofRotateY(y.get());
	}
	PPort y;
};

/**
 * @brief PRotZ class
 * @description 
 * @note 
 */
class PRotZ : public PDrawStyle {
public:
	PGenConstructor1Arg(PRotZ, z)
	
	void drawStyle() {
		ofRotateZ(z.get());
	}
	PPort z;
};

/**
 * @brief PColor class
 * @description 
 * @note 
 */
class PColor : public PDrawStyle {
public:
	PGenConstructor3Arg(PColor, r, g, b);
	PColor(ofColor col) : r(col.r), g(col.g), b(col.b) {}
	void drawStyle() {
		ofSetColor(r.get(), g.get(), b.get());
	}
	PPort r, g, b;
};

/**
 * @brief PColor class
 * @description 
 * @note 
 */
class PColor4 : public PDrawStyle {
public:
	PGenConstructor4Arg(PColor4, r, g, b, a);
	PColor4(ofColor col) : r(col.r), g(col.g), b(col.b), a(col.a) {}
	void drawStyle() {
		ofSetColor(r.get(), g.get(), b.get(), a.get());
	}
	PPort r, g, b, a;
};

} // namespace psig
