#include "PDraw.h"
#include "GrColors.h"

/**
 * @brief PRect::draw
 */
void PRect::draw() {
	double dw = w;
	double dh = h;
	
	ofSetPolyMode(OF_POLY_WINDING_ODD);
	ofBeginShape();
	ofVertex(0, 0);
	ofVertex(0, dh);
	ofVertex(dw, dh);
	ofVertex(dw, 0);
	ofVertex(0, 0);
	ofEndShape();
	ofPopMatrix();
}

/**
 * @brief PCircle::draw
 */
void PCircle::draw()
{
	double dw = w;
	double dh = h;
	double dnum = num;
	int nn = dnum;
	double phase = 2 * PI / (int)nn;

	ofSetPolyMode(OF_POLY_WINDING_ODD);
	ofBeginShape();

	for(int i = 0; i < (nn + 1); i++) {
		double xx = - sin(phase * i);
		double yy = - cos(phase * i);
		ofVertex(xx * dw, yy * dh);
	}
	
	ofEndShape();
}

/**
 * @brief PRing::draw
 */
void PRing::draw()
{
	double dw = w;
	double dh = h;
	double dnum = num;
	double dwei = weight;
	int nn = dnum;
	double phase = 2 * PI / (int)nn;
	
	ofSetPolyMode(OF_POLY_WINDING_ODD);
	ofBeginShape();

	for(int i = 0; i < (nn + 1); i++) {
		double xx = - sin(phase * i);
		double yy = - cos(phase * i);
		ofVertex(xx * dw, yy * dh);
	}

	dw -= dw * dwei;
	dh -= dh * dwei;
	
	for(int i = 0; i < (nn + 1); i++) {
		double xx = - sin(phase * i);
		double yy = - cos(phase * i);
		ofVertex(xx * dw, yy * dh);
	}
	
	ofEndShape();
}

/**
 * @brief PRingRect::draw
 */
void PRingRect::draw() {
	double dw = w;
	double dh = h;
	double dwei = weight;

	printf("%f, %f\n", dw, dh);
	
	dw *= 0.5;
	dh *= 0.5 ;
	
	ofSetPolyMode(OF_POLY_WINDING_ODD);
	ofBeginShape();
	ofVertex(-dw, -dh);
	ofVertex(-dw, dh);
	ofVertex(dw, dh);
	ofVertex(dw, -dh);
	ofVertex(-dw, -dh);

	dw -= dw * dwei;
	dh -= dh * dwei;

	ofVertex(-dw, -dh);
	ofVertex(-dw, dh);
	ofVertex(dw, dh);
	ofVertex(dw, -dh);
	ofVertex(-dw, -dh);
	
	ofEndShape();
	ofPopMatrix();
}

inline double moduloOne(double in)
{
	if((in > 1) || (in < 0)) {
		int temp = in;
		in -= temp;
	}
	return in;
}

/**
 * @brief PArc::draw
 */
void PArc::draw()
{
	double dw = w;
	double dh = h;
	double dnum = num;
	double dwei = weight;
	double dradS = (radS);
	double dradE = (radE);

	dradS = moduloOne(dradS);
	dradE = moduloOne(dradE);

	dradS *= (2 * PI);
	dradE *= (2 * PI);

	if(dradS > dradE) {
		// double temp = dradE;
		// dradE = dradS;
		// dradS = temp;
		dradS -= 1.0;
	}
	
	int nn = dnum * (dradE - dradS);

	double radStep  = (dradE - dradS) / nn;
	
	ofBeginShape();

	for(int i = 0; i < nn+1; i++) {
		double p = dradS + (radStep * i);
		double xx = - sin(p);
		double yy = - cos(p);
		ofVertex(xx * dw, yy * dh);
	}
	
	dw -= dw * dwei;
	dh -= dh * dwei;
	
	for(int i = 0; i < nn+1; i++) {
		double p = dradE - (radStep * i);
		double xx = - sin(p);
		double yy = - cos(p);
		ofVertex(xx * dw, yy * dh);
	}
	
	ofEndShape();
}

