//
//  GrButton.h
//  myNewApp
//
//  Created by 三分一 修 on 2013/06/22.
//
//

#ifndef __GrButton__
#define __GrButton__

#include "GrMain.h"

typedef enum gr_button_event_kind
{
	GR_BUTTON_PRESSED,
	GR_BUTTON_RELEASED,
	GR_BUTTON_ENTERED,
	GR_BUTTON_OUT
} eGrButtonEventKind;

class GrButton;

class GrButtonListener
{
public:
	virtual void buttonNotify(eGrButtonEventKind kind, GrButton *button) = 0;
};

class GrButton : public GrDrawer, GrUpdater, GrMouse
{
public:
	GrButton(int x, int y, int w, int h);
	
	virtual void update();
	virtual void draw();

	virtual void mouseMoved(int x, int y );
	virtual void mouseDragged(int x, int y, int button);
	virtual void mousePressed(int x, int y, int button);
	virtual void mouseReleased(int x, int y, int button);

	void setFill(bool f) { this->fill = f; }
	void setColor(int r, int g, int b);
	void setColor(const ofColor &c);
	void addButtonListener(GrButtonListener *listener);
	void removeButtonListener(GrButtonListener *listener);
	
private:
	bool fill;
	int mx, my, mw, mh;
	int mr, mg, mb;
	std::vector<GrButtonListener*> mButtonListeners;
	eGrButtonEventKind mButtonStatus;
};

#endif // __GrButton__
