/*
 * SynthForm.cpp
 *
 *  Created on: 2009/08/18
 *      Author: sambuichi
 */

#include "RtStk.h"
#include "SynthManager.h"
#include "Arpeggiator.h"

SynthManager::SynthManager() : channel(0) {

}

SynthManager::~SynthManager() {
	// TODO Auto-generated destructor stub
}

//! w肵ÕVZ[hiVSTȉꍇdll̃t@Cj
void SynthManager::loadSynth(const char *name, int programNumber)
{
	// VZ쐬A~LT[ɒǉ
	RtStk *rtstk = RtStk::getInstance();
	currentSynth = SynthFactory::create(name);
	if(currentSynth) {	// Synth Load
		currentSynth->setProgram(programNumber);
		rtstk->mixer.add(currentSynth);
		synths.push_back(currentSynth);
		this->channel = currentSynth->getChannel();
		synthChangedCall(currentSynth);
	}
}

void SynthManager::setCurrentSynth(int i)
{
	currentSynth = synths.at(i);
	this->channel = currentSynth->getChannel();
	synthChangedCall(currentSynth);
}

void SynthManager::addSynthChangedListener(SynthChangedListener *synthChangedListener)
{
	synthChangedListeners.push_back(synthChangedListener);
}

inline void SynthManager::synthChangedCall(Synth *synth) {
	for(vector<SynthChangedListener*>::iterator itr = synthChangedListeners.begin(); itr != synthChangedListeners.end(); itr++) {
		((SynthChangedListener*)*itr)->synthChanged(currentSynth);
	}
}


