#ifndef _SYNTH_
#define _SYNTH_

#include <vector>
#include <string>
#include "ticker.h"
#include "Stk.h"
#include "SKINI.msg"
#include "Skini.h"

using namespace stk;
using namespace std;

class Synth : public Ticker {
public:
	Synth();
	virtual ~Synth() {};

	int id;
	float volume;
	string name;

	virtual float tick() = 0;
	virtual float tick(float **buffer, unsigned int channel, unsigned int num) = 0;

	virtual void setProgram(int programNumber) = 0;
	virtual void processMessage(Skini::Message &message) = 0;

	virtual int getNumPrograms();
	virtual int getNumParams();
	virtual void getParamName(int paramIndex, char *ptr);
	virtual void getProgramName(int prgIndex, char *ptr);

	void setName(string name) { this->name = name; }
	string getName() {	return name; }

	void setChannel(int channel) { this->channel = channel; }
	int getChannel() { return this->channel; }

private:
	int channel;
	static int idcnt;
};

#endif
