/*
 * Stki.h
 *
 *  Created on: 2009/08/20
 *      Author: sambuichi
 */

#ifndef STKI_H_
#define STKI_H_

#include <map>
#include "Synth.h"
#include "Instrmnt.h"
#include "Voicer.h"

#define NUM_INSTS 28
#define INST_CLARINET  0x0000 // ng
#define INST_BLOWHOLE  0x0001
#define INST_SAXOFONY  0x0002 // ng
#define INST_FLUTE     0x0003 // ok
#define INST_BRASS     0x0004
#define INST_BLOWBOTL  0x0005
#define INST_BOWED     0x0006
#define INST_PLUCKED   0x0007 // ok
#define INST_STIFKARP  0x0008
#define INST_SITAR     0x0009 // ng?
#define INST_MANDOLIN  0x000a
#define INST_RHODEY    0x000b
#define INST_WURLEY    0x000c // ok
#define INST_TUBEBELL  0x000d
#define INST_HEVYMETL  0x000e
#define INST_PERCFLUT  0x000f
#define INST_BEETHREE  0x0010
#define INST_FMVOICES  0x0011 // ng?
#define INST_VOICFORM  0x0012
#define INST_MOOG      0x0013 // ok (very small sound)
#define INST_SIMPLE    0x0014
#define INST_DRUMMER   0x0015
#define INST_BANDEDWG  0x0016
#define INST_SHAKERS   0x0017
#define INST_MODALBAR  0x0018
#define INST_MESH2D    0x0019
#define INST_RESONATE  0x001a
#define INST_WHISTLE   0x001b

#define NO_STK_INST_NAME (char*)"NoStkName"

class Stki : public Synth {
public:
	Stki(string name = NO_STK_INST_NAME);
	virtual ~Stki();

	float tick();
	virtual float tick(float **buffer, unsigned int channel, unsigned int num);
	void setInstruments(int instNum, int numVoice);
	void setInstNumber(int num) { this->instNumber = num; }
	int getInstNumber() { return this->instNumber; }
	virtual void setProgram(int programNumber);
	virtual void processMessage(Skini::Message &message);

	static int getStkInstNumber(const char *name);
	static char *getStkInstName(int num);

private:
	Instrmnt *instByNumber(int number);
	Instrmnt *instByName(char *name);
	char *instNum2Str(int inst_num);

	int instNumber;
	stk::Voicer voicer;
	std::vector<stk::Instrmnt*> insts;

	static char stkInstNames[NUM_INSTS][10];

	static map<int,long> idToTagMap;	// bZ[WIDƃm[gԍ̑ΉMAPiNoteOn/OFFpj
	static void mapIDToTag(int id, long tag);
	static long getTagFromID(int id);
};

#endif /* STKI_H_ */
