/*
 * SequenceManage.h
 *
 *  Created on: 2009/11/14
 *      Author: ox
 */

#ifndef SEQUENCEMANAGE_H_
#define SEQUENCEMANAGE_H_

#include "Mutex.h"
#include "Metro.h"
#include "Sequence.h"

class SequenceManage : public MetroListener {
public:
	SequenceManage();
	virtual ~SequenceManage();

	Sequence *getSequence(int sequenceID);
	void removeFromSequencer(Sequence *seq);
	void removeFromSequencer(int sequenceID);
	virtual void metroEvent(Metro *metro);
	Sequence *seqRecEnd();
	void setSequenceChannel(int channel);

	virtual void sequencerEventProcessed(Sequence *seq, Sequence::Message &msg) = 0;

protected:
	Sequence *currentSequence;
	vector<Sequence*> sequences;
	Mutex sequencesMutex;

private:
	int currentChannel;
};

#endif /* SEQUENCEMANAGE_H_ */
