/*
 * SequenceManage.cpp
 *
 *  Created on: 2009/11/14
 *      Author: ox
 */

#include "SequenceManage.h"
#include "RtStk.h"

SequenceManage::SequenceManage() {
	RtStk::getInstance()->metro.addMetroListener(this);
	currentSequence = new Sequence();
	sequences.push_back(currentSequence);
}

SequenceManage::~SequenceManage() {
	// TODO Auto-generated destructor stub
}

//! MetrǒĂяo
void SequenceManage::metroEvent(Metro *metro)
{
//	printfunc
	float time = metro->getCurrentTime();
	float duration = metro->getDiacDuration();

	sequencesMutex.lock();	// V[PT̒ǉ֎~;

	for(vector<Sequence*>::iterator itr = sequences.begin(); itr != sequences.end(); itr++) {
		Sequence tmpseq;
		Sequence *seq = ((Sequence*)*itr);
		float time_offset = seq->subseq(tmpseq, time, duration);	// metroEventԂ̃Cxgo
		for(vector<Sequence::Message>::iterator it = tmpseq.getMessages().begin();
				it != tmpseq.getMessages().end(); it++) {
			Sequence::Message sm = (Sequence::Message)*it;
			Skini::Message msg = ((Sequence::Message)(*it)).msg;
			msg.time += time_offset;	// V[PXԁDACԂ̕ϊ
			RtStk::getInstance()->messager.pushMessage(msg);		//

			if(!sm.loop) {
				seq->removeMessage(sm.id);						// Sequencer::Message̗vf폜
			}
			sequencerEventProcessed(seq, sm);		// Cxg𓊂
		}
	}

	sequencesMutex.unlock();
}

/*!
 * w肵Sequence폜
 */
void SequenceManage::removeFromSequencer(Sequence *seq) {
	//! sequencerseq폜
	sequencesMutex.lock();
	for(vector<Sequence*>::iterator itr = sequences.begin(); itr != sequences.end(); itr++) {
		if(*itr == seq) {
			sequences.erase(itr);
			delete seq;
			break;	// SequencerɓSequencedēo^ĂȂ̂Ƃčl
		}
	}
	sequencesMutex.unlock();
}

/*!
 * w肵Sequence폜
 */
void SequenceManage::removeFromSequencer(int sequenceID) {
	//! sequencerseq폜
	sequencesMutex.lock();
	for(vector<Sequence*>::iterator itr = sequences.begin(); itr != sequences.end(); itr++) {
		if(((Sequence*)*itr)->getID() == sequenceID) {
			sequences.erase(itr);
			delete ((Sequence*)*itr);
			break;	// SequencerɓSequencedēo^ĂȂ̂Ƃčl
		}
	}
	sequencesMutex.unlock();
}

Sequence *SequenceManage::getSequence(int sequenceID) {
	//! sequencerseq폜
	Sequence *seq = 0;
	sequencesMutex.lock();
	for(vector<Sequence*>::iterator itr = sequences.begin(); itr != sequences.end(); itr++) {
		if(((Sequence*)*itr)->getID() == sequenceID) {
			seq = ((Sequence*)*itr);
			break;	// SequencerɓSequencedēo^ĂȂ̂Ƃčl
		}
	}
	sequencesMutex.unlock();
	return seq;
}


void SequenceManage::setSequenceChannel(int channel)
{
	currentChannel = channel;
	currentSequence->setChannel(currentChannel);	// ݂̃V[PX̃`lݒ
}

/*!
 * VV[PXJnāAJgV[PXƂ
 * \return recordIV[PX
 */
Sequence *SequenceManage::seqRecEnd()
{
	Sequence *oldseq = currentSequence;	// ̃V[PXreturnpɕێ
	currentSequence = new Sequence();	// ݂̃V[PXVK쐬̂ɒu
	currentSequence->setChannel(currentChannel);	// VKV[PX̃`lݒ
	sequencesMutex.lock();
	sequences.push_back(currentSequence);		// VK̃V[PXۑ
	sequencesMutex.unlock();
	return oldseq;
}
