#include "mixer.h"
#include <vector>

using namespace std;

int Track::idcnt = 0;

static int track_next_id = 0;

Track::Track() : volume(1.0)
{
	this->id = idcnt++;
}

float Track::tick(float **buffer, unsigned int channel, unsigned int num)
{
//	last_output = ticker->tick();
	last_output = synth->tick(buffer, channel, num);
	last_output *= volume;
//	for(vector<Effect*>::iterator itr = effects.begin(); itr != effects.end(); itr++) {
//		Effect *ef = (Effect *) *itr;
//		last_output = ef->tick(last_output);
//	}
	return last_output;
}

void Mixer::init(unsigned int channels, unsigned int bufferFrames)
{
	this->channels = channels;
	this->bufferFrames = bufferFrames;
	frameBuffer = new float*[channels];
	for(unsigned int i = 0 ; i < channels; i++) {
		frameBuffer[i] = new float[bufferFrames];
	}
}

//void Mixer::add(Ticker *synth)
void Mixer::add(Synth *synth)
{
	Track *tk = new Track();
	tk->synth = synth;
	tracks.push_back(tk);
}

float Mixer::tick(float **buffer, unsigned int channel, unsigned int num)
{
	int cnt = 0;
	last_output = 0;

	// obt@̃[
	for(unsigned int i = 0 ; i < channel; i++) {
		for(unsigned int k = 0; k < num; k++) {
			buffer[i][k] = 0;
		}
	}

	for(vector<Track*>::iterator itr = tracks.begin(); itr != tracks.end(); itr++) {
		Track *tk = (Track*) *itr;
		last_output += tk->tick(frameBuffer, channel, num);
		for(unsigned int i = 0 ; i < channel; i++) {
			for(unsigned int k = 0; k < num; k++) {
				buffer[i][k] += frameBuffer[i][k];
			}
		}
	}
	last_output *= volume;

	return last_output;
}



