#include "Arpeggiator.h"
#include "Sequence.h"

Arpeggiator::Arpeggiator() :
	patternBits(ARP_1000),
	patternLength(4),
	patternShift(0),
	unitDiacritic(2)
{
	_note = new ArpValueFunc(60);
	_velocity = new ArpValueFunc(80);
	_duration = new ArpValueFunc(1);
}

Arpeggiator::~Arpeggiator()
{
	delete _note;
	delete _velocity;
	delete _duration;
}


void Arpeggiator::setPattern(unsigned int pattern)
{
	this->patternBits = pattern;
}

void Arpeggiator::setPatternShift(unsigned int shift)
{
	if(shift + patternLength <= MAX_ARP_LENGTH) {
		this->patternShift = shift;
	}
}

void Arpeggiator::setPatternLength(unsigned int length)
{
	if(patternShift + length <= MAX_ARP_LENGTH) {
		this->patternLength = length;
	}
}

void Arpeggiator::setNoteFunc(AbstructArpFunc *noteFunc)
{
	AbstructArpFunc *org = _note;
	_note = noteFunc;
	delete org;
}

void Arpeggiator::setVelocityFunc(AbstructArpFunc *velocityFunc)
{
	AbstructArpFunc *org = _velocity;
	_velocity = velocityFunc;
	delete org;
}

void Arpeggiator::setDurationFunc(AbstructArpFunc *durationFunc)
{
	AbstructArpFunc *org = _duration;
	_duration = durationFunc;
	delete org;
}

/*
int Arpeggiator::getNote(int index)
{
	// T.B.D
	return note;
}

int Arpeggiator::getVelocity(int index)
{
	// T.B.D
	return velocity;
}

int Arpeggiator::getDuration(int index)
{
	// T.B.D
	return duration;
}
*/

void Arpeggiator::apply(Sequence *seq)
{
	unsigned int pbits = patternBits >> patternShift;
	unsigned int bitInd = 1 << (patternLength - 1);
	unsigned int cnt = 0;

	unsigned int seqDiacLength = seq->getBeat() * seq->getDiac();
	unsigned int seqdiac = 0;

	while(seqdiac < seqDiacLength) {
		if(pbits & bitInd) { // bit pattern on
			unsigned int arrayIndex = MAX_ARP_LENGTH - 1 - ((cnt % patternLength) + patternShift);
			int note = _note->getIndexValue(arrayIndex); // getNote(arrayIndex);
			int velo = _velocity->getIndexValue(arrayIndex); // getVelocity(arrayIndex);
			int duration = _duration->getIndexValue(arrayIndex); // getDuration(arrayIndex);
			printf ("%d %d %d\n", note, velo, duration);
			int beat = (int)(seqdiac / seq->getDiac());
			int diac = (int)(seqdiac % seq->getDiac());
			seq->addNote(note, velo, beat, diac, duration);
		}

		bitInd = bitInd >> 1;
		if(! bitInd) { // 0 bit pattern loop
			bitInd = 1 << (patternLength - 1);
		}
		cnt++;
		seqdiac = cnt * unitDiacritic;
	}
}

unsigned int majorScale[SCALE_OCTAVE] = {
	0, 0, 2, 2, 4, 5, 5, 7, 7, 9, 9, 11
};

unsigned int minorScale[SCALE_OCTAVE] = {
	0, 0, 2, 3, 3, 5, 5, 7, 8, 8, 10, 10
};

int ArpNoteScaleFunc::getIndexValue(int index) {
	int _value = rand() % (maxValue - minValue) + minValue;
	int octave = _value / SCALE_OCTAVE;
	int note = _value % SCALE_OCTAVE;
	unsigned int scale_note = 0;
	switch(scale) {
	case SCALE_MAJOR:
		scale_note = majorScale[note];
		break;
	case SCALE_MINOR:
		scale_note = minorScale[note];
		break;
	default:
		scale_note = note;
		break;
	}
	_value = octave * SCALE_OCTAVE + scale_note;
	return _value;
}

int ArpRandomFunc::getIndexValue(int index) {
	int _value = rand() % (maxValue - minValue) + minValue;
	return _value;
}
