#include "meta-string.h"

meta_string::meta_string(string str)
{
	this->str = str;
	this->flag = METASTR_NORMAL;
	default_param();
}

meta_string::meta_string(unsigned int flag)
{
	this->flag = flag;
	if(flag == METASTR_SPACE) {
		this->str = "  ";
	}
	default_param();
}

void meta_string::draw(FTFont *font)
{
 	glColor3f(red, green, blue);
	font->Render(str.c_str());
}

void meta_string::operator+=(char c)
{
	str += c;
}

void meta_string::setColor(float r, float g, float b)
{
	this->red   = r;
	this->green = g;
	this->blue  = b;
}

void meta_string::setSize(unsigned int size)
{
	this->fontsize = size;
}

int meta_string::length()
{
	return this->str.length();
}

void meta_string::substr(int start, int length)
{
	str = str.substr(start, length);
}

void meta_string::substr(int start)
{
	str = str.substr(start);
}

float meta_string::getBBwidth()
{
	return (bb.urx - bb.llx);
}

float meta_string::getBBheight()
{
	return (bb.ury - bb.lly);
//	return (bb.ury + bb.lly);
//	return bb.ury;
}

void meta_string::debug_print_mstr()
{
	switch(flag) {
	case METASTR_BREAK:
		cout << "META enter" << endl;
		break;
	case METASTR_SPACE:
		cout << "META space" << endl;
		break;
	default:
		cout << str << endl;
		break;
	}
}

void meta_string::updateBB(FTFont *font)
{
	font->BBox(str.c_str(), bb.llx, bb.lly, bb.llz, bb.urx, bb.ury, bb.urz);
#ifdef COUT_BBOX_VALUE
	cout	<< __FILE__ << endl
			<< "bb.llx " << bb.llx << endl
			<< "bb.lly " << bb.lly << endl
			<< "bb.llz " << bb.llz << endl
			<< "bb.urx " << bb.urx << endl
			<< "bb.ury " << bb.ury << endl
			<< "bb.urz " << bb.urz << endl;
#endif
}

void meta_string::default_param()
{
	this->fontsize = 20;
	this->red   = 0.5;
	this->green = 0.5;
	this->blue  = 0.5;
	next = NULL;
	prev = NULL;
}



