/*
 * ftlabel.h
 *
 *  Created on: 2009/01/18
 *      Author: sambuichi
 */

#ifndef FTLABEL_H_
#define FTLABEL_H_

#include "ftglfont.h"
#include "graphic/UnitForm.h"
#include "graphic/port/Positionable.h"
#include "graphic/port/Resizable.h"
#include "graphic/port/Colorful.h"

class ftlabel :
	public UnitForm,
	public Positionable,
	public Resizable,
	public Colorful
{
public:
	ftlabel(string label, int font_type = FTGL_PIXMAP,
			float size = 0.04, float posx = 0.5, float posy = 0.5, FontAlign align = ALIGN_LEFT,
			float red = 0.5, float green = 0.5, float blue = 0.5, float alpha = 0.7);
	virtual ~ftlabel();

	void update();
	void camera();
	void draw();

	//! p[^ݒ
	void setSize(float size);
	void setActive(bool active);

	string getLabel();
	void setLabel(string str);
	float getLabelWidth();
	float getLabelHeight();
	bool isArea(float x, float y);

private:
	string str;
	FTFont *font;
	FontAlign align;

	int cnt;
	bool active;
};

#endif /* FTLABEL_H_ */
