/*
 * FTLabelFactory.h
 *
 *  Created on: 2009/01/23
 *      Author: sambuichi
 */

#ifndef FTLABELFACTORY_H_
#define FTLABELFACTORY_H_

//typedef enum {
//	FT_LABEL_UNIT_NAME,
//} FtLabelType;
#include "graphic/text/ftlabel.h"

class FTLabelFactory {
public:
	//! Singleton
	static FTLabelFactory *getInstance()
	{
		static FTLabelFactory *instance = 0;
		if(instance == 0) {
			instance = new FTLabelFactory();
		}
		return instance;
	}
	virtual ~FTLabelFactory();

	ftlabel *simpleLabel(string label, float x = 0.5, float y = 0.5, float size = 0.05,
			float r = 0.5, float g = 0.5, float b = 0.5, float a = 0.5);
	ftlabel *focusedUnitNameLabel(string label, float r = 0.8, float g = 0.2, float b = 0.1, float a = 0.6);
	ftlabel *focusChangeUnitNameLabel(string name, float r = 0.2, float g = 0.1, float b = 0.7, float a = 0.6);
	ftlabel *unitHelpLabel(string name, int row = 0, float r = 0.2, float g = 0.1, float b = 0.7, float a = 0.7);
	ftlabel *mouseMonitorLabel(string label);
	ftlabel *unitParamMonitorLabel(int row);
	ftlabel *grPortListLabel(string name, int row, int max_row);
	ftlabel *syListLabel(string name, int row, int max_row);
	ftlabel *paramListLabel(string label, int row, int max_row, float listPosx, float listPosy);
	ftlabel *gridPositionLabel(string label, float posx = 0.5, float posy = 0.5);

private:
	FTLabelFactory();
};

#endif /* FTLABELFACTORY_H_ */
