/*
 * FTFontBuilder.h
 *
 *  Created on: 2009/01/18
 *      Author: sambuichi
 */

#ifndef FTFONTBUILDER_H_
#define FTFONTBUILDER_H_

#include "ftglfont.h"

#define DEFAULT_FONT_DATA "./data/ttf/arial.ttf"

class FTFontBuilder {
public:
	/*!
	 * Singleton
	 */
	static FTFontBuilder *getInstance()
	{
		static FTFontBuilder *builder = 0;
		if(builder == 0) {
			builder = new FTFontBuilder();
		}
		return builder;
	}

	virtual ~FTFontBuilder();

	FTFont *createFont(int font_type = FTGL_PIXMAP, char *font_data = DEFAULT_FONT_DATA, bool share = false);

private:
	FTFontBuilder();
	FTFont *createPixmapFont(char *font_data);
};

#endif /* FTFONTBUILDER_H_ */
