#include "common.h"
#include "opengl-func.h"
#include "SinTable.h"

/*!
 * ~`ixRg[jp̃e[u
 * `TCYɉVertex̐ω
 */
#define NUM_APC_TABLE 7

static int limits[NUM_APC_TABLE] = {
	8,
	20,
	50,
	100,
	200,
	400,
	800,
};

static int num_points[NUM_APC_TABLE] = {
	16,
	32,
	64,
	128,
	256,
	512,
	1028,
};

static double *table_c[NUM_APC_TABLE] = {
	&cos_table16[0],
	&cos_table32[0],
	&cos_table64[0],
	&cos_table128[0],
	&cos_table256[0],
	&cos_table512[0],
	&cos_table1024[0],
};

static double *table_s[NUM_APC_TABLE] = {
	&sin_table16[0],
	&sin_table32[0],
	&sin_table64[0],
	&sin_table128[0],
	&sin_table256[0],
	&sin_table512[0],
	&sin_table1024[0],
};

static void circle_apc(float size);
static void circle_n(float size, int n, double sin_table[], double cos_table[]);
static void ring_apc(float size, float width);
static void ring_n(float size, float width, int n, double sin_table[], double cos_table[]);

void rect_corner_nofill(float ww, float hh)
{
	glPushMatrix();
 	glBegin(GL_LINES);

	glVertex3f(0, 0, 0);
	glVertex3f(ww, 0, 0);

	glVertex3f(ww, 0, 0);
	glVertex3f(ww, -hh, 0);

	glVertex3f(ww, -hh, 0);
	glVertex3f(0, -hh, 0);

	glVertex3f(0, -hh, 0);
	glVertex3f(0, 0, 0);

	glEnd();
	glPopMatrix();
}

void rect_corner_nofill_from_bl(float ww, float hh)
{
	glPushMatrix();
 	glBegin(GL_LINES);

	glVertex3f(0, 0, 0);
	glVertex3f(ww, 0, 0);

	glVertex3f(ww, 0, 0);
	glVertex3f(ww, hh, 0);

	glVertex3f(ww, hh, 0);
	glVertex3f(0, hh, 0);

	glVertex3f(0, hh, 0);
	glVertex3f(0, 0, 0);

	glEnd();
	glPopMatrix();
}

void rect_center(float ww, float hh)
{
	glPushMatrix();
	glTranslatef(-ww/2, - hh/2, 0);
 	glBegin(GL_POLYGON);
// 	glBegin(GL_LINES);
	glVertex3f(0, 0, 0);
	glVertex3f(ww, 0, 0);
	glVertex3f(ww, hh, 0);
	glVertex3f(0, hh, 0);
	glEnd();
	glPopMatrix();
}

void rect_center_nofill(float ww, float hh)
{
	glPushMatrix();
	glTranslatef(-ww/2, - hh/2, 0);
 	glBegin(GL_LINES);

	glVertex3f(0, 0, 0);
	glVertex3f(ww, 0, 0);

	glVertex3f(ww, 0, 0);
	glVertex3f(ww, hh, 0);

	glVertex3f(ww, hh, 0);
	glVertex3f(0, hh, 0);

	glVertex3f(0, hh, 0);
	glVertex3f(0, 0, 0);

	glEnd();
	glPopMatrix();
}

/*!
 * ~
 */
void circle(float size) {
	glBegin(GL_LINE_LOOP);
	circle_apc(size);
	glEnd();
}

/*!
 * ~ihԂj
 */
void circlef(float size) {
	glBegin(GL_POLYGON);
	circle_apc(size);
	glEnd();
}

/*!
 * ~iAuto Precision Controlj
 */
static void circle_apc(float size)
{
	for(int i = 0; i < NUM_APC_TABLE; i++) {
		if(size*0.2 < limits[i]) {
			circle_n(size, num_points[i], table_s[i], table_c[i]);
			return;
		}
	}
}

//! draw circle with 1024, 512, 256, 128 points
/*!
 * ~i|Cgwj
 */
static void circle_n(float size, int n, double sin_table[], double cos_table[])
{
	for(int i = 0; i < n; i++) {
		glVertex3f(-size * sin_table[i], size * cos_table[i], 0);
	}
}

/*!
 * 
 */
void ring(float size, float inner_size) {
	glBegin(GL_LINE_LOOP);
	circle_apc(size);
	circle_apc(inner_size);
	glEnd();
}

/*!
 * ցihԂj
 */
void ringf(float size, float inner_size) {
	ring_apc(size, inner_size);
}

/*!
 * ցihԂjiAuto Precision Controlj
 */
static void ring_apc(float size, float inner_size)
{
	for(int i = 0; i < NUM_APC_TABLE; i++) {
		if(size*0.2 < limits[i]) {
			ring_n(size, inner_size, num_points[i], table_s[i], table_c[i]);
			return;
		}
	}
}

//! draw circle with 1024, 512, 256, 128 points
/*!
 * ցihԂji|Cgwj
 */
static void ring_n(float size, float inner_size, int n, double sin_table[], double cos_table[])
{
	float inner = inner_size;

#if 0
	glBegin(GL_POLYGON);
	for(int i = 0; i <= n/4; i++) {
		glVertex3f(-pixelSize * sin_table[i], pixelSize * cos_table[i], 0);
	}
	for(int i = n/4; i >= 0; i--) {
		glVertex3f(-inner * sin_table[i], inner * cos_table[i], 0);
	}
	glEnd();

//	for(int i = 0; i < (n-1); i++) {
////		glEdgeFlag(GL_FALSE);
//		glBegin(GL_POLYGON);
//		glVertex3f(size * sin_table[i], size * cos_table[i], 0);
//		glVertex3f(size * sin_table[i+1], size * cos_table[i+1], 0);
//		glVertex3f(inner * sin_table[i+1], inner * cos_table[i+1], 0);
//		glVertex3f(inner * sin_table[i], inner * cos_table[i], 0);
//		glEnd();
//	}
////	glVertex3f(size * sin_table[0], size * cos_table[0], 0);
////	glVertex3f(inner * sin_table[0], inner * cos_table[0], 0);
#else
	glBegin(GL_TRIANGLE_STRIP);
	for(int i = 0; i < n; i++) {
		glVertex3f(size * sin_table[i], size * cos_table[i], 0);
		glVertex3f(inner * sin_table[i], inner * cos_table[i], 0);
	}
	glVertex3f(size * sin_table[0], size * cos_table[0], 0);
	glVertex3f(inner * sin_table[0], inner * cos_table[0], 0);
	glEnd();
#endif
}
