/*
 * Positionable.cpp
 *
 *  Created on: 2009/02/17
 *      Author: sambuichi
 */

#include "Positionable.h"
#include "PositionPort.h"
#include "graphic/GlutMain.h"

Positionable::Positionable(float posx, float posy, float posz)
{
	setPos(posx, posy, posz);
}

Positionable::~Positionable() {
}

/*!
 *	\brief positionablẽp[^Rs[
 */
void *Positionable::setPos(const Positionable &positionable)
{
	setPos(positionable.getX(), positionable.getY(), positionable.getZ());
	return this;
}

/*!
 * \brief ʒu͉ʍ̑Έʒu0~1̐KꂽlŎw肷
 */
void Positionable::setPos(float posx, float posy, float posz)
{
	setX(posx);
	setY(posy);
	setZ(posz);
}

/*!
 * setter
 */
void Positionable::setX(float posx)
{
	float fw = GlutMain::width;
	this->nx = posx;
	this->pixelX = fw * (posx - 0.5);
}

void Positionable::setY(float posy)
{
	float fh = GlutMain::height;
	this->ny = posy;
	this->pixelY = fh * (0.5 - posy);
}

void Positionable::setZ(float posz)
{
	float fw = GlutMain::height;
	this->nz = posz;
	this->pixelZ = fw * (posz - 0.5);
}

/*!
 * getter
 */
float Positionable::getX() const
{
	return nx;
}

float Positionable::getY() const
{
	return ny;
}

float Positionable::getZ() const
{
	return nz;
}

/*!
 * getter
 */
float Positionable::getPixelX() const
{
	return pixelX;
}

float Positionable::getPixelY() const
{
	return pixelY;
}

float Positionable::getPixelZ() const
{
	return pixelZ;
}

/*!
 *
 */
float Positionable::distance(Positionable *p)
{
	float dx = nx - p->nx;
	float dy = ny - p->ny;
	float dz = nz - p->nz;
	return sqrt(dz*dz + sqrt(dx*dx + dy*dy));
}

void Positionable::debugPrintPosition() {
	printfunc;
	cout << "X=" << pixelX << ", Y=" << pixelY << ", Z=" << pixelZ << endl;
}
