/*
 * AppMng.cpp
 *
 *  Created on: 2009/09/29
 *      Author: ox
 */

#include "AppMng.h"
#include "FocusMng.h"

AppMng::AppMng() : app(0) {
	printfunc
	FocusMng::getInstance()->addFocusChangeListener(this);
}

AppMng::~AppMng() {
	// TODO Auto-generated destructor stub
}

void AppMng::start()
{
	mutex.lock();
	if(AppForm *appf = dynamic_cast<AppForm*>(FocusMng::getInstance()->getCurrent())) {
		app = appf;
	}
	mutex.unlock();
}

void AppMng::update()
{
	mutex.lock();
	if(app) {
		((UnitMng*)app)->update();	// AppŊǗUniťĂяo
		app->update();
	}
	mutex.unlock();
}

void AppMng::draw()
{
	mutex.lock();
	if(app) {
		((UnitMng*)app)->draw();	// AppŊǗUniťĂяo
		app->camera();
		app->draw();
	}
	mutex.unlock();
}

void AppMng::addApp(AppForm *app)
{
	FocusMng::getInstance()->addFocusListener(app);
}

/*!
 * AppFocusύXʒm
 */
void AppMng::focusChanged(FocusListener *beforeFocus, FocusListener *afterFocus)
{
	printfunc
	//! VFocusACeAppFormȂ
	if(AppForm *appf = dynamic_cast<AppForm*>(afterFocus)) {
		mutex.lock();
		this->app = appf;
		mutex.unlock();
	} else {
		mutex.lock();
		this->app = 0;
		mutex.unlock();
	}
}
