/*
 * VstiParamList.cpp
 *
 *  Created on: 2009/08/26
 *      Author: sambuichi
 */

#include "VstiParamList.h"
#include "graphic/GlutMain.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/updater/UpdaterGrPort.h"

VstiParamList::VstiParamList(Synth *synth, int selectedIndex, int viewListLength,
		float listPosx, float listPosy)  :
	synth(synth),
	listRow(viewListLength),
	listTopVectorIndex(1),
	paramViewTopIndex(selectedIndex),
	labelMoveFrameCount(4),
	moving(LabelStop),
	movingCount(0)
{
	ftlabel *ftLabel;

	// \p̑ҋ@x
	ftLabel = FTLabelFactory::getInstance()->paramListLabel("", -1, listRow, listPosx, listPosy);
	labels.push_back(ftLabel);
	GlutMain::addUnit(ftLabel);

	// Xg\p̃x
	for(int i = 0; i < listRow; i++)
	{
		char _name[256] = {0};
		synth->getParamName(paramViewTopIndex + i, _name);
		string name = _name;
		ftLabel = FTLabelFactory::getInstance()->paramListLabel(name, i, listRow, listPosx, listPosy);
		labels.push_back(ftLabel);
		GlutMain::addUnit(ftLabel);
	}

	// Xg擪ACeep[^擾
	labelAlpha = labels.at(1)->getA();
	labelAlphaEmphasis = 0.8;
	listTopY = labels.at(1)->getY();
	listRowHeight = labels.at(0)->getY() - labels.at(1)->getY();

	// 擪x\
	ftLabel = labels.at(listTopVectorIndex);
	ftLabel->updateAlpha(labelAlpha, labelMoveFrameCount);

	// Ix͂g
	rect = new Rect();
	rect->setAlign(SHAPE_CORNER_LEFT_BOTTOM);
	rect->setFill(false);
	rect->setX(labels.at(1)->getX());
	rect->setY(listTopY - listRowHeight * 0.2);
	rect->setWidth((labels.at(1)->getLabelWidth()+5) / GlutMain::width);
	rect->setHeight(listRowHeight);

	GlutMain::addUnit(rect);
}

VstiParamList::~VstiParamList() {
	// TODO Auto-generated destructor stub
	printfunc
	for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
		printfunc
		ftlabel *label = (ftlabel*)*itr;
		label->updateAlpha(labelAlpha, 0, 0, 10);
		label->updateDelete(10);
	}
	rect->updateDelete(10);
}

int VstiParamList::getSelectedIndex()
{
	return paramViewTopIndex;
}

/*!
 * ݕ\Ă閖p[^̎̃p[^\
 */
void VstiParamList::next()
{
	printfunc
	// ݕ\Ă閖VZp[^Indexp[^𒴉߂ĂȂ
	char _name[256] = {0};
	string prevLabel;
	if(paramViewTopIndex + listRow < synth->getNumParams()) { // Xg
		paramViewTopIndex++;
		synth->getParamName(paramViewTopIndex+listRow-1, _name);
		prevLabel = _name;
	} else if(paramViewTopIndex + 1 < synth->getNumParams()) {
		paramViewTopIndex++;
		prevLabel = "";
	} else { // łɖvfXg擪ɕ\Ă
		cout << "no more next list item" << endl;
		return;
	}

	// VZp[^\̃L[ɒǉ
	LabelItem labelItem = {prevLabel, LabelNext};
	queue.push_back(labelItem);
}

/*!
 * ݕ\Ă擪p[^ÕVZp[^\
 */
void VstiParamList::prev()
{
	printfunc
	if(paramViewTopIndex > 0) {	// ݕ\Ă擪VZp[^IndexPȏł
		paramViewTopIndex--;
	} else { // łɐ擪p[^\Ă̂őÕp[^݂͑Ȃ
		cout << "no more prev list item" << endl;
		return;
	}

	char _name[256] = {0};
	synth->getParamName(paramViewTopIndex, _name);
	string prevLabel = _name;

	// VZp[^\̃L[ɒǉ
	LabelItem labelItem = {prevLabel, LabelPrev};
	queue.push_back(labelItem);
}

void VstiParamList::draw()
{

}

inline void VstiParamList::moveSpeedAdjust()
{
	if(queue.size() > 5) {
		labelMoveFrameCount = 1;
	} else if(queue.size() > 3) {
		labelMoveFrameCount = 2;
	} else if(queue.size() > 1) {
		labelMoveFrameCount = 3;
	} else {
		labelMoveFrameCount = 4;
	}
}

inline void VstiParamList::prevLabelView(string labelString)
{
	unsigned int index = 0;
	ftlabel *label = 0;

	// 擪x̋\
	label = labels.at(listTopVectorIndex);
	label->updateAlpha(labelAlpha, labelMoveFrameCount);

	// \Xg̐擪listRow̃xړ
	for(int i = 0; i < listRow; i++) {
		index = listTopVectorIndex + i;
		if(index >= labels.size()) {
			index -= labels.size();
		}
		label = labels.at(index);
		label->updateY(label->getY()-listRowHeight, labelMoveFrameCount);
	}
	//! vf͈ړƓɃtF[hAEg
	label = labels.at(index);
	label->updateAlpha(0, labelMoveFrameCount);

	// ҋ@xXg̘gOXChC
	int listWaitIndex = listTopVectorIndex - 1;
	if(listWaitIndex < 0) {
		listWaitIndex = listRow;
	}
	label = labels.at(listWaitIndex);
	label->setA(0);
	label->setY(listTopY + listRowHeight);
	label->setLabel(labelString);
	label->updateY(label->getY()-listRowHeight, labelMoveFrameCount);
	label->updateAlpha(0, labelAlphaEmphasis, 0, labelMoveFrameCount);

	// \XǵiVectorj擪CfbNXP߂
	listTopVectorIndex = listWaitIndex;
}

inline void VstiParamList::nextLabelView(string labelString)
{
	unsigned int index = 0;
	ftlabel *label = 0;
	// \Xg̐擪listRow̃xړ
	for(int i = 0; i < listRow; i++) {
		index = listTopVectorIndex + i;
		if(index >= labels.size()) {
			index -= labels.size();
		}
		label = labels.at(index);
		label->updateY(label->getY()+listRowHeight, labelMoveFrameCount);
	}
	//! 擪x͈ړƓɃtF[hAEg
	label = labels.at(listTopVectorIndex);
	label->updateAlpha(0, labelMoveFrameCount);

	// ҋ@xXg̘gOXChC
	int listWaitIndex = listTopVectorIndex - 1;
	if(listWaitIndex < 0) {
		listWaitIndex = listRow;
	}
	label = labels.at(listWaitIndex);
	label->setA(0);
	label->setY(listTopY - listRowHeight * listRow);
	label->setLabel(labelString);
	label->updateY(label->getY()+listRowHeight, labelMoveFrameCount);
	label->updateY(0, labelAlpha, 0, labelMoveFrameCount);

	// \XǵiVectorj擪CfbNXPi߂
	listTopVectorIndex++;
	if(listTopVectorIndex >= listRow + 1) {
		listTopVectorIndex = 0;
	}

	// V擪x\
	label = labels.at(listTopVectorIndex);
	label->updateAlpha(labelAlphaEmphasis, labelMoveFrameCount);
}

void VstiParamList::update()
{
//	printfunc

	if(moving == LabelStop) {	// x\Î~
		if(queue.size()) {		// ɕ\郉x̃L[ɃACe
			cout << "queue front pop    queue size = " << queue.size() << endl;
			LabelItem labelItem = queue.front();	// ɕ\郉x̐擪vf擾
			queue.erase(queue.begin());				// 擾擪vf폜
			moving = labelItem.direct;	// x\ԂNEXT, PREVɐݒ

			moveSpeedAdjust();

			movingCount = labelMoveFrameCount;
			if(moving == LabelNext) {	// ̃x\
				nextLabelView(labelItem.label);
			} else if(moving == LabelPrev){
				prevLabelView(labelItem.label);
			}

			ftlabel *label = labels.at(listTopVectorIndex);
			rect->setWidth((label->getLabelWidth()+5) / GlutMain::width);
		}
	} else {
	}
	if(movingCount > 0) {
		movingCount--;
		if(movingCount <= 0) {
			moving = LabelStop;
		}
	}
}
