/*
 * GridEventView.h
 *
 *  Created on: 2009/11/18
 *      Author: ox
 */

#ifndef GRIDEVENTVIEW_H_
#define GRIDEVENTVIEW_H_

#include "graphic/comp/InputEvents.h"
#include "graphic/comp/EventView.h"
#include "graphic/comp/GridFigure.h"
#include "graphic/comp/GridMaster.h"
#include "graphic/port/Colorful.h"
#include "Mutex.h"

using namespace std;

class GridEventView;
class GridAreaView;
class GridTrajView;

struct Area {
	int maxx;
	int maxy;
	int minx;
	int miny;
	Area() : maxx(INT_MIN), maxy(INT_MIN), minx(INT_MAX), miny(INT_MAX) {}
};

struct EventViewVector {
	vector<EventView*> vector;
	GridAreaView *areaView;
	void show();
	void hide();
	void erase();
	void point(int x, int y);
};
typedef struct EventViewVector EventViewVector;

class GridEventView : public EventView {
public:
	GridEventView(GridFigureFactory &figureFactory, GridMaster &gridMaster);
	virtual ~GridEventView();

	void show();	//! SEvent\
	void hide();	//! SEvent\
	void show(int eventID);	//! Event\
	void hide(int eventID);
	void point(int x, int y);
	void select(int x, int y);
	void remove(int eventID);
	void entryEvents(int eventID, vector<InputEvent> &inputEvents);
	vector<int> getPointedEventIDs();

protected:
	GridFigureFactory &figureFactory;	// `nh
	GridMaster &gridMaster;				//

	vector<int> pointedEvents;
	map<int,EventViewVector*> eventViewMap;

	Mutex eventViewMutex;
};

//! GridCxg͈̔͂\
class GridAreaView : public EventView {
public:
	GridAreaView(GridFigureFactory &figureFactory, vector<InputEvent> &inputEvents);
	virtual ~GridAreaView() {};
	void show();
	void hide();
	void point(int x, int y);
	void select(int x, int y);
	bool isArea(int x, int y);
private:
	GridFigureFactory &figureFactory;	// `nh
	vector<InputEvent> inputEvents;
	CellFigureHandle *figure;
	Area area;
	bool rollovering;
	Colorful color, highColor;
};

//! GridCxg̋OՂ\
class GridTrajView : public EventView {
public:
	GridTrajView(GridFigureFactory &figureFactory, vector<InputEvent> &inputEvents);
	virtual ~GridTrajView() {};
	void show();
	void hide();
	void point(int x, int y);
	void select(int x, int y);
	void highlight(bool t);
private:
	void drawInputPoint(InputEvent &ie);
	void drawCellLine(InputEvent &ie1, InputEvent &ie2);
	GridFigureFactory &figureFactory;	// `nh
	vector<InputEvent> inputEvents;
	vector<CellFigureHandle*> figureHandles;	// `IuWFNg
	Colorful color, highColor;
	Mutex gridTrajMutex;
};



#endif /* GRIDEVENTVIEW_H_ */
