#ifndef VDATA_H_
#define VDATA_H_

#include "common.h"

class vdata {
public:
	float v;
	float min;
	float max;
	float d;

	vdata(float v = 1, float min = 0, float max = 1, float d = 0)
	: v(v), min(min), max(max), d(d) {}

	//!
	float operator=(float val) {	return v = val; }

	//!
	operator float() { return v; }

	float next() {
		v += d;
		if(v > max) {
			v -= (max - min);
		} else if(v < min) {
			v += (max - min);
		}
		return v;
	}
};

class vsin : public vdata {
public:
	float phase;
	float rad;

	vsin(float v = 1, float min = 0, float max = 1, float d = 0, float phase = 0)
	: vdata(v, min, max, d), phase(phase), rad(0) {}

	//! sinl
	float next() {
		v = (sin(phase + rad) + 1) * 0.5 * (max - min) + min; //! 0~1
		rad += d;	//! 1cycle 0.5sec
		return v;
	}
};

/*!
 * ԁitjw肵sin𓾂
 */
class vsint
{
public:
	float v;
	float min;
	float max;
	float phase;
	float T;	//! P̎ԁisecj
	float hb;	//! ő-ŏl̔̕
	float angleRate;	//! pxibɐiރWAj

	vsint(float min = 0, float max = 1, float T = 1, float phase = 0)
		: min(min), max(max), phase(phase), T(T)
	{
		hb = (max - min) * 0.5;
		angleRate = TWO_PI / (float) T;
	}

	//! w肵ԂSinl
	float t(float t) {
		float rad = phase + angleRate * t;
		v = (sin(rad) + 1) * 0.5 * (max - min) + min; //! 0~1
		return v;
	}
};

class vfall
{
private:
	float T1, T2;
	float T1_over;
	float T2_over;
	float T_over;
	float bb;

public:
	float v;
	float min;
	float max;
	float phase;
	float T;	//! P̎ԁisecj
	float ratio;

	vfall(float min = 0, float max = 1, float T = 1, float ratio = 0.1)
		: min(min), max(max), T(T), ratio(ratio)
	{
		time(T, ratio);
		band(min, max);
	}

	void time(float T, float ratio) {
		this->T = T;
		this->ratio = ratio;
		T1 = T * ratio;
		T2 = T - T1;
		T_over = 1.0 / T;
		T1_over = 1.0/ T1;
		T2_over = 1.0/ T2;
	}

	void band(float min, float max) {
		this->min = min;
		this->max = max;
		bb = max - min;
	}

	float t(float t) {

		//! tɎ߂
		if(t > T) {
			int tn = (int) (t * T_over);
			t -= tn * T;
		}

		if(t < T1) {
			v = min + bb * t * T1_over;
		} else {
			v = max - bb * (t - T1) * T2_over;
		}
//		float T1 = T * 0.2;
//		if(t < T1) {
//			float tt = t / T1;
//			v = min + (max - min) * tt;
//		} else {
//			float tt = (t - T1) / (T-T1);
//			v = max + (min - max) * tt;
//		}

		return v;
	}
};

#endif
