/*
 * SyList.h
 *
 *  Created on: 2009/02/18
 *      Author: sambuichi
 */

#ifndef SYLIST_H_
#define SYLIST_H_

#include "common.h"
#include "graphic/mng/KeyMng.h"

class Synth;
class ftlabel;

class SyList : public KeyInputListener {
public:
	SyList();
	virtual ~SyList();

	void keyFunc(int key, int action);
	void focusOn();
	void focusOff();

private:
	Mutex synthLabelsLock;
	void createSynthLabels();
	void createSynthPortLabels(Synth *synth);
	void deleteLabels();

	void nextFocusLabel();
	void prevFocusLabel();

	vector<Synth*> synths;
	vector<ftlabel*> labels;

	ftlabel *currentFocusLabel;

	void setFocusColor(bool on);
};

#endif /* SYLIST_H_ */
