/*
 * GrPortList.cpp
 *
 *  Created on: 2009/02/17
 *      Author: sambuichi
 */

#include "GrPortList.h"
#include "graphic/updater/Updater.h"
#include "graphic/text/ftlabel.h"
#include "graphic/text/FTLabelFactory.h"
#include "graphic/port/PositionPort.h"
#include "graphic/port/SizePort.h"

GrPortList::GrPortList(Unit *u) : currentFocusLabel(NULL)
{
	printfunc;
	if(Positionable *pos = dynamic_cast<Positionable*>(u)) {
		ports.push_back(new XPort(pos));
		ports.push_back(new YPort(pos));
		ports.push_back(new ZPort(pos));
	}

	//! |[g̃x쐬Vectorɒǉ
	int row = 0;
	for(vector<GrPort*>::iterator itr = ports.begin(); itr != ports.end(); itr++) {
		string name = ((GrPort*)*itr)->getName();
		ftlabel *ftl = FTLabelFactory::getInstance()->grPortListLabel(name, row++, ports.size());
		labels.push_back(ftl);
		GraphicWindowMng::getInstance()->getMng()->addUnit(ftl, 0);
	}

//	new PortUpdater((GrPort*)ports.at(0));
}

GrPortList::~GrPortList() {
	//! |[g폜
	for(vector<GrPort*>::iterator itr = ports.begin(); itr != ports.end(); itr++) {
		delete (GrPort*)*itr;
	}

	//! x폜
	for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
//		labels.erase(itr);	//! Ō̂ЂƂȂ!!!!!
//		GraphicWindowMng::getInstance()->getMng()->removeUnit((ftlabel*)*itr, 0);
		((ftlabel*)*itr)->die();
		cout << "ftlabel dead " << __FILE__ << " " << __LINE__ << " " << *itr << endl;
	}
}

void GrPortList::setFocusColor(bool on)
{
	if(currentFocusLabel == NULL) {
		if(labels.size() > 0) {
			currentFocusLabel = labels.at(0);
		}
	}

	if(currentFocusLabel != NULL) {
		if(on) {
			currentFocusLabel->setColor(0.9, 0.1, 0.2, 0.7);
		} else {
			currentFocusLabel->setColor(0.5, 0.5, 0.5, 0.5);
		}
	}
}

void GrPortList::keyFunc(int key, int action)
{
	switch(key) {
	case GLFW_KEY_UP:
		setFocusColor(false);
		for(vector<ftlabel*>::reverse_iterator itr = labels.rbegin(); itr != labels.rend(); itr++) {
			if(currentFocusLabel == (ftlabel*)*itr) {
				if((itr+1) != labels.rend()) {
					currentFocusLabel = *(itr+1);
					break;
				}
			}
		}
		setFocusColor(true);
		break;
	case GLFW_KEY_DOWN:
		setFocusColor(false);
		for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
			if(currentFocusLabel == (ftlabel*)*itr) {
				if((itr+1) != labels.end()) {
					currentFocusLabel = *(itr+1);
					break;
				}
			}
		}
		setFocusColor(true);
		break;
	default:
		break;
	}
}

void GrPortList::focusOn()
{
	printunitfuncfocus;
	setFocusColor(true);

//	for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
//		ftlabel *lbl = (ftlabel*)*itr;
//		new PortUpdater(new XPort(lbl), lbl->getX()-0.1, lbl->getX(), 10);
//		new PortUpdater(new SizePort(lbl), 0.05, 0.10, 10);
//	}
}

void GrPortList::focusOff()
{
	printunitfuncfocus;
	setFocusColor(false);
//	for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
//		ftlabel *lbl = (ftlabel*)*itr;
//		new PortUpdater(new XPort(lbl), lbl->getX(), lbl->getX()-0.1, 10);
//		new PortUpdater(new SizePort(lbl), 0.10, 0.05, 10);
//	}
}
