/*
 * CtrlE.cpp
 *
 *  Created on: 2009/02/10
 *      Author: sambuichi
 */

#include "CtrlE.h"
#include "graphic/primitive/Ring.h"
#include "graphic/primitive/opengl-func.h"
#include "graphic/updater/UpdaterKillUnit.h"

CtrlE::CtrlE() :
	vs1(0, 0.2, 2),
	vs2(0.3, 0.8, 5),
	pm(15),
	dcnt(0),
	shapeLifeMin(30),
	shapeLifeMax(100),
	mouse_rotate_flag(0)
{
	DeclareName;
}

CtrlE::~CtrlE() {
	// TODO Auto-generated destructor stub
}

void CtrlE::draw()
{
	if(!active) return;

	int i = 0;

	if(space_flag) {
		glShadeModel(GL_SMOOTH);
	} else {
		glShadeModel(GL_FLAT);
	}

	if(mouse_rotate_flag) {
		rx = mx * 360;
		ry = my * 360;
	}
	glRotatef(rx, 1, 0, 0);
	glRotatef(ry, 0, 1, 0);

	glColor4f(0.2, 0.8, 0.1, 0.5);
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POLYGON_SMOOTH);
	circlef(mx * 150);
	ringf(my * 200, mx * 100);

	lock();
	float num_over = num_shape_over;
	for(vector<Shape*>::iterator itr = begin(); itr < end(); itr++) {
		glPushMatrix();
		float rot = (dcnt * 360 * framerate_over * 0.5);
		glRotatef(rot, 0, 0, 1);

		Shape *shape = (Shape*) *itr;
//		float v1 = vs1.t(dcnt * framerate_over * 0.1 );
//		float v2 = vs2.t(dcnt * framerate_over * 0.1 );
		float v1 = vs1.t(dcnt * framerate_over * 0.5 * (i * num_over * vs1.T));
		float v2 = vs2.t(dcnt * framerate_over * 0.5 * (i * num_over * vs2.T));
//		float v3 = vs3.t(dcnt * framerate_over * 0.5 + (i * num_over * vs3.T));
		i++;

		shape->setPos(v1, v2, 0.5);

		shape->update();
		shape->draw();
		glPopMatrix();
	}
	unlock();

	loopend();

	dcnt++;
}

//void CtrlE::battutaEvent(int b)
//{
//	if(!active) return;
//
//	if(nrand() < 0.5) {
//		float ringSize = 100+nrand()*400;
//		float ringRatio = nrand()*0.5;
//		Ring *s = new Ring(ringRatio);
//		s->setColor(0.5, 0.2, 0.4, 0.5);
//		s->setFill(true);
//		new UpdaterKillUnit(s, (int)(shapeLifeMin + (shapeLifeMax-shapeLifeMin) * nrand()));
//		s->setSize(ringSize);
//		addShape(s);
//	}
//}

void CtrlE::mousePosition(int x, int y)
{
	bool ctrl  = KeyMng::getInstance()->CTRL;
	bool alt   = KeyMng::getInstance()->ALT;
	bool shift = KeyMng::getInstance()->SHIFT;
	mx = mousex() * width_over;
	my = mousey() * height_over;

	if(ctrl && alt) {
		vs1.T = mx * 10;
		vs2.T = my * 10;
	} else if(ctrl && shift) {
		shapeLifeMin = (int)(mx * 100);
		shapeLifeMax = shapeLifeMin + (int)(my * 100);
	} else if(ctrl) {
		vs1.min = mx * 2;
		vs1.max = my * 2;
	} else if(alt) {
		vs2.min = mx * 2;
		vs2.max = my * 2;
	}
}

void CtrlE::update()
{
	if(!active) return;

	pm.labelStart();
	pm.addLabel("[CTRL + mouseX, mouseY]");
	pm.addLabel("vs1 min=", vs1.min);
	pm.addLabel("vs1 max=", vs1.max);
	pm.addLabel("[ALT + mouseX, mouseY]");
	pm.addLabel("vs2 min=", vs2.min);
	pm.addLabel("vs2 max=", vs2.max);
	pm.addLabel("[CTRL + ALT + mouseX, mouseY]");
	pm.addLabel("vs1 T=", vs1.T);
	pm.addLabel("vs2 T=", vs2.T);
	pm.addLabel("[CTRL + SHIFT + mouseY]");
	pm.addLabel("shapeLifeMin=", shapeLifeMin);
	pm.addLabel("shapeLifeMax=", shapeLifeMax);
	pm.addLabel("-> num=", num_shape);
	pm.addLabel("[SPACE + mouseX, mouseY]");
	pm.addLabel("object rotate X=", rx);
	pm.addLabel("object rotate Y=", ry);
}

void CtrlE::setActive(bool active) {
	this->active = active;
	pm.setActive(active);
}

void CtrlE::keyFunc(int key, int action) {
	if(key == GLFW_KEY_SPACE) {
		space_flag = action;
		mouse_rotate_flag = action;
	}
}
