/*
 * CtrlS.h
 *
 *  Created on: 2009/03/10
 *      Author: sambuichi
 */

#ifndef CTRL_MOUSE_NOTE_ON_DEMO_A_H_
#define CTRL_MOUSE_NOTE_ON_DEMO_A_H_

#include "CtrlForm.h"
#include "ShapePool.h"
#include "graphic/primitive/opengl-func.h"
#include "graphic/primitive/Shape.h"

class CtrlDemoMouseNoteOnA :
	public CtrlForm,
	public ShapePool
{
private:
	class NoteOnCircle : public Shape {
	public:
		Synth *synth;
		long notetag;

		NoteOnCircle(Synth *synth) {
			this->synth = synth;
			this->notetag = synth->noteOn(60, 60);
		};
		virtual ~NoteOnCircle() {
			this->synth->noteOff(notetag, 0);
		};
		void graphics() {
			circlef(hsize);
		}
	};

public:
	CtrlDemoMouseNoteOnA();
	virtual ~CtrlDemoMouseNoteOnA();

	void draw();
	void mouseFunction(int x, int y, int state);
	void mousePosition(int x, int y){}

private:
	bool active;
	Synth *synth;
};

#endif /* CTRL_MOUSE_NOTE_ON_DEMO_A_H_ */
