/*
 * Param.h
 *
 *  Created on: 2009/04/15
 *      Author: sambuichi
 */
#ifndef PARAM_H_
#define PARAM_H_

#include <string>

using namespace std;

class Param {
public:
	Param(string name, float v, float min, float max);
	virtual ~Param();

	friend float operator-(int v, Param& param);
	friend float operator-(float v, Param& param);
	friend float operator/(int v, Param& param);
	friend float operator/(float v, Param& param);

	//! 0~1KꂽlԂ
	float norm() {
		return ((val-min) * over );
	}

	//! 0~1Kꂽlݒ
	float norm(float v) {
		val = min + ((max-min) * v);
		return val;
	}

	operator int() {
		return (int) val;
	}

	operator float() {
		return val;
	}

	bool changed() {
		return chg;
	}

	void nochange() {
		chg = false;
	}

	void setchange() {
		chg = true;
	}

	//! =
	Param &operator=(int v) {
		val = v;
		setchange();
		return *this;
	}

	Param &operator=(float v) {
		val = v;
		setchange();
		return *this;
	}

	//! +=
	float operator+=(int v) {
		val += v;
		setchange();
		return val;
	}

	float operator+=(float v) {
		val += v;
		setchange();
		return val;
	}

	//! +
	float operator+(int v) {
		return val + v;
	}

	float operator+(float v) {
		return val + v;
	}

	//! -=
	float operator-=(int v) {
		val -= v;
		setchange();
		return val;
	}

	float operator-=(float v) {
		val -= v;
		setchange();
		return val;
	}

	//! -
	float operator-(int v) {
		return val - v;
	}

	float operator-(float v) {
		return val - v;
	}

	//! *=
	float operator*=(int v) {
		val *= v;
		setchange();
		return val;
	}

	float operator*=(float v) {
		val *= v;
		setchange();
		return val;
	}

	//! *
	float operator*(int v) {
		return val * v;
	}

	float operator*(float v) {
		return val * v;
	}

	//! /=
	float operator/=(int v) {
		val /= v;
		setchange();
		return val;
	}

	float operator/=(float v) {
		val /= v;
		setchange();
		return val;
	}

	//! /
	float operator/(int v) {
		return val / (float)v;
	}

	float operator/(float v) {
		return val / v;
	}

	//! ==
	bool operator==(int v) {
		return (val == v);
	}

	bool operator==(float v) {
		return (val == v);
	}

	//! !=
	bool operator!=(int v) {
		return (val != v);
	}

	bool operator!=(float v) {
		return (val != v);
	}

	//! <
	bool operator<(int v) {
		return (val < v);
	}

	bool operator<(float v) {
		return (val < v);
	}

	//! <=
	bool operator<=(int v) {
		return (val <= v);
	}

	bool operator<=(float v) {
		return (val <= v);
	}

	//! >
	bool operator>(int v) {
		return (val > v);
	}

	bool operator>(float v) {
		return (val > v);
	}

	//! >=
	bool operator>=(int v) {
		return (val >= v);
	}

	bool operator>=(float v) {
		return (val >= v);
	}

	string name;

private:
	float val;
	float min;
	float max;
	float over;
	bool chg;
};

inline float operator+(int v, Param& param)
{
	return param + v;
}

inline float operator+(float v, Param& param)
{
	return param + v;
}

inline float operator-(int v, Param& param)
{
	return v - param.val;
}

inline float operator-(float v, Param& param)
{
	return v - param.val;
}

inline float operator*(int v, Param& param)
{
	return param * v;
}

inline float operator*(float v, Param& param)
{
	return param * v;
}

inline float operator/(int v, Param& param)
{
	return v / param.val;
}

inline float operator/(float v, Param& param)
{
	return v / param.val;
}

inline bool operator!=(int v, Param& param)
{
	return (param != v);
}

inline bool operator!=(float v, Param& param)
{
	return (param != v);
}

inline bool operator==(int v, Param& param)
{
	return (param == v);
}

inline bool operator==(float v, Param& param)
{
	return (param == v);
}

inline bool operator<(int v, Param& param)
{
	return param > v;
}

inline bool operator<(float v, Param& param)
{
	return param > v;
}

inline bool operator<=(int v, Param& param)
{
	return param >= v;
}

inline bool operator<=(float v, Param& param)
{
	return param >= v;
}

#endif /* PARAM_H_ */
