/*
 * CtrlMovingRubber.cpp
 *
 *  Created on: 2009/04/04
 *      Author: sambuichi
 */

#include "CtrlMovingRubber.h"
#include "graphic/GlutMain.h"
#include "graphic/updater/UpdaterFactory.h"
#include "graphic/primitive/ShapeFactory.h"
#include "graphic/primitive/Circle.h"

const unsigned char CtrlMovingRubber::moveStop;
const unsigned char CtrlMovingRubber::rollover;
const unsigned char CtrlMovingRubber::selected;

CtrlMovingRubber::CtrlMovingRubber() :
	focusedPoint(0),
	flag(0),
	spring("spring", 0.01, 0.001, 0.5)
{
	DeclareName
}

CtrlMovingRubber::~CtrlMovingRubber() {
	deleteAll();
}

void CtrlMovingRubber::draw()
{
	if(!active) return;

	mutex.lock();	//! Lock

	//! draw point & lines
	for(vector<_point*>::iterator itr = points.begin(); itr != points.end(); itr++){
		_point *p = (_point*)*itr;
		Circle *cir = ShapeFactory::smallRedPoint(p->getX(), p->getY());
		UpdaterFactory::fadeoutUnit(cir, 0.4, 2, 5);
		addUnit(cir);
		p->drawing = cir;

		//! }EXE[I[o[̕`揈
		if(p->state & rollover) {
			Rect *rect = new Rect();
			rect->copyShape(*cir);
			rect->setFill(false);
			UpdaterFactory::fadeoutUnit(rect, 0.4, 3, 4);
			addUnit(rect);

			cir->setB(1.0);
		}
		//! selectedԂ_point̕`揈
		if(p->state & selected) {
			Rect *rect = new Rect();
			rect->copyShape(*cir);
			rect->setFill(false);
			rect->setSize(rect->getSize()*1.5);
			UpdaterFactory::fadeoutUnit(rect, 0.4, 3, 4);
			addUnit(rect);
		}
	}

	if(flag & moveStop) return;

	//! update line force & point vector
	int n = 0;
	for(vector<_line*>::iterator itr = lines.begin(); itr != lines.end(); itr++, n++) {
		_line *line = (_line*)*itr;
		_point *p1 = line->p1;
		_point *p2 = line->p2;

		addUnit((Unit*)ShapeFactory::fadeLine(p1->drawing, p2->drawing));

		//! update line spring
		float distance = p1->distance(p2);
		float force = (line->length - distance) * line->length_over * line->spring;

		float fx = force * (p1->getX() - p2->getX());
		p1->xv += fx;
		p2->xv -= fx;

		float fy = force * (p1->getY() - p2->getY());
		p1->yv += fy;
		p2->yv -= fy;
	}

	//! updater point location
	for(vector<_point*>::iterator itr = points.begin(); itr != points.end(); itr++) {
		_point *p = (_point*)*itr;
		p->setX(p->getX() + p->xv);
		p->setY(p->getY() + p->yv);

		p->xv *= 0.98;
		p->yv *= 0.98;
	}

	mutex.unlock();	//! Unlock
}

/*!
 *	\brief ׂĂ_point, _line폜
 */
void CtrlMovingRubber::deleteAll()
{
	deletePoints();
	deleteLines();
}

/*!
 *	\brief ׂĂPoint폜
 */
void CtrlMovingRubber::deletePoints()
{
	mutex.lock();
	while(!points.empty()) {
		_point *p = points.back();
		points.pop_back();
		delete p;
	}
	mutex.unlock();
}

/*!
 *	\brief ׂĂLine폜
 */
void CtrlMovingRubber::deleteLines()
{
	mutex.lock();
	while(!lines.empty()) {
		_line *line = lines.back();
		lines.pop_back();
		delete line;
	}
	mutex.unlock();
}

/*!
 *	\brief _ЂƂǉ
 *	\param x ẍʒuiO`PŎwj
 *	\param y ÿʒuiO`PŎwj
 *	\param fric CW
 */
CtrlMovingRubber::_point *CtrlMovingRubber::addPoint(float x, float y, float fric = 0, float xv = 0, float yv = 0)
{
	_point *p = new _point();
	p->setX(x);
	p->setY(y);
	points.push_back(p);
	return p;
}

/*!
 *	\brief _lineЂƂǉ
 *	\param p1 _lineȂ_
 *	\param p2 _lineȂ_
 *	\param length _line̒i͂ĂȂj
 *	\param length<=0w肵ꍇ݂͌p1, p2Ԃ̋𒷂Ƃ
 */
CtrlMovingRubber::_line *CtrlMovingRubber::addLine(_point *p1, _point *p2, float length = 0, float spring = 0.05)
{
	_line *line = new _line();
	line->p1 = p1;
	line->p2 = p2;
	line->length = length;
	if(length <= 0) {
		line->length = p1->distance(p2);
	}
	line->length_over = 1.0 / line->length;
	line->spring = this->spring;
	lines.push_back(line);
	return line;

}

/*!
 *	\brief L[͏
 *	\brief Space:ԂœXgbv
 */
void CtrlMovingRubber::keyFunc(int key, int action) {
	switch(key) {
	case KEY_SPACE:
		flag = flag ^ moveStop;
		break;
	default:
		break;
	}
}

/*!
 *	\brief }EX̓
 */
void CtrlMovingRubber::mousePosition(int x, int y)
{
	//! moveStopԂł_point̃[I[o[
	if(flag & moveStop) {
		for(vector<_point*>::iterator itr = points.begin(); itr != points.end(); itr++) {
			_point *p = (_point*)*itr;
			float nx = xmouse2norm(x);
			float ny = ymouse2norm(y);
			if(p->inArea(nx, ny)) {
//				p->rollover = true;
				p->state = p->state | rollover;
			} else {
//				p->rollover = false;
				p->state = p->state & (0xff ^ rollover);
			}
		}

	}
}

/*!
 *	\brief }EXPress, Release
 */
void CtrlMovingRubber::mouseFunction(int x, int y, int state)
{
	mutex.lock();
	if(state) {
		//! moveStopԂł_point̑I𔻒
		if(flag & moveStop) {
			bool rolloverHit = false;
			for(vector<_point*>::iterator itr = points.begin(); itr != points.end(); itr++) {
				_point *p = (_point*)*itr;
				if(p->state & rollover) {
					p->state = p->state ^ selected;	//! selectedԐ؂ւ
					focusedPoint = p;				//! focusĂ_pointi_lineڑ̑ΏۂɂȂ_pointjXV
					rolloverHit = true;
				}
			}
			if(rolloverHit) return;	//! ȍ~̏i_point̒ǉj͎sȂ
		}
		/*
		 * }EXNbNE_Eœ_ЂƂǉAtH[JX
		 * Ă_iftHgł͍ŋߒǉꂽ́j̊Ԃ
		 */
		_point *p = addPoint(width_over*x, height_over*y, 0.98);
		if(focusedPoint) {
			addLine(focusedPoint, p, 0.4);
		}
		this->focusedPoint = p;
	}
	mutex.unlock();
}

