/*
 * CtrlD.cpp
 *
 *  Created on: 2009/02/09
 *      Author: sambuichi
 */

#include "CtrlD.h"

CtrlD::CtrlD() :
	vf1(0.5, 0.9, 3, 0.5),
	pm(10, this),
	shapes(36)
{
	DeclareName
}

CtrlD::~CtrlD() {
	// TODO Auto-generated destructor stub
}

void CtrlD::update()
{
	if(!active) return;

	pm.labelStart();
	pm.addLabel("vf1 min=", vf1.min);
	pm.addLabel("vf1 max=", vf1.max);
	pm.addLabel("vf1 T=", vf1.T);
	pm.addLabel("vf1 ratio=", vf1.ratio);
	pm.addLabel();
	pm.addLabel("num=", shapes.num);
}

void CtrlD::draw()
{
	if(!active) return;

	int i = 0;

	shapes.lock();
	float num_over = shapes.num_over;
	for(vector<Shape*>::iterator itr = shapes.begin(); itr < shapes.end(); itr++) {

		glPushMatrix();

		float rot = (dcnt * 360 * framerate_over * 0.1) + (360 * num_over * i++);
		glRotatef(rot, mx, my, 1);

		Shape *r = (Shape*) *itr;
		float v1 = vf1.t(dcnt * framerate_over + i * vf1.T * num_over);
		r->setPos(0.5, v1, 0.5);

		r->update();
		r->draw();

		glPopMatrix();
	}
	shapes.unlock();

	dcnt++;
}

void CtrlD::mousePosition(int x, int y)
{
	bool ctrl  = KeyMng::getInstance()->CTRL;
	bool alt   = KeyMng::getInstance()->ALT;
	bool shift = KeyMng::getInstance()->SHIFT;
	mx = mousex() * width_over;
	my = mousey() * height_over;
	if(ctrl && alt) {

	} else if(ctrl && shift) {
		shapes.build((int)(my * 128));
	} else if(alt) {
//		vf1.T = mx * 10;
//		vf1.ratio = my;
		vf1.time(mx * 10, my);
	} else if(ctrl) {
//		vf1.max = mx;
//		vf1.min = my;
		vf1.band(mx, my);
	}
}

void CtrlD::keyFunc(int key, int action)
{

}

void CtrlD::setActive(bool active) {
	this->active = active;
#ifdef _FTGL_ENABLE_
	pm.setActive(active);
#endif
}


