/*
 * SynthSelectLabel.h
 *
 *  Created on: 2009/09/16
 *      Author: sambuichi
 */

#ifndef SYNTHSELECTLABEL_H_
#define SYNTHSELECTLABEL_H_

#include "sound/SynthManager.h"
#include "graphic/text/FTLabelFactory.h"

//#define SYNTH_SELECT_LABEL_SIZE 	0.05
//#define SYNTH_SELECT_LIST_SIZE 	0.04
//#define SYNTH_SELECT_LABEL_MARGIN 	0.01

class SynthSelectLabel {
public:
	SynthSelectLabel(SynthManager *synthForm, float x, float y);
	virtual ~SynthSelectLabel();

	void set(Synth *synth);
	void select(float x, float y);
	void rollover(float x, float y);

private:
	SynthManager *synthManager;
	ftlabel *currentLabel;
	vector<ftlabel*> list;
	float x, y;
	bool listing;

	string getSynthString(Synth *synth);
	void showList();
	void hideList();

	bool isListArea(float x, float y);
};

#endif /* SYNTHSELECTLABEL_H_ */
