/*
 * SynthSelectLabel.cpp
 *
 *  Created on: 2009/09/16
 *      Author: sambuichi
 */

#include "Layout.h"
#include "SynthSelectLabel.h"
#include "graphic/updater/UpdaterGrPort.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/GlutMain.h"

//Colorful Layout::col;

SynthSelectLabel::SynthSelectLabel(SynthManager *synthForm, float x, float y) :
	synthManager(synthForm), currentLabel(0), x(x), y(y), listing(false)
{
	currentLabel = FTLabelFactory::getInstance()->simpleLabel("no synth", x, y, Layout::synthSelectLabelSize);
	GlutMain::addUnit(currentLabel);
}

SynthSelectLabel::~SynthSelectLabel() {
	// TODO Auto-generated destructor stub
}

void SynthSelectLabel::set(Synth *synth)
{
	string l = getSynthString(synth);
	if(currentLabel) {
		currentLabel->updateAlpha(0, 10);
		currentLabel->updateDelete(5);		// label폜
	}
	currentLabel = FTLabelFactory::getInstance()->simpleLabel(l, x, y, Layout::synthSelectLabelSize);
	currentLabel->setColor(Layout::SynthSelectLabelColor);
	float originalAlpha = currentLabel->getA();
	currentLabel->setA(0);
//	new UpdaterGrPort(currentLabel->newAPort(), 0, originalAlpha, 0, 10);
	currentLabel->updateAlpha(originalAlpha, 10);
	GlutMain::addUnit(currentLabel);
}

inline string SynthSelectLabel::getSynthString(Synth *synth) {
	int channel = synth->getChannel();
	char charstr[64];
	sprintf(charstr, "%d", channel);
	string channelStr = charstr;
	string l = "noSynth";
	if(synth) {
		l = synth->getName() + "  ch:" + channelStr;
	}
	return l;
}

/*!
 * Synth⃊Xg\
 */
inline void SynthSelectLabel::showList() {
	vector<Synth*> &synths = synthManager->getSynths();
	float listy = y;
//	float lineMargin = (currentLabel->getLabelHeight() / (float) GlutMain::height) + Layout::synthSelectLabelMargin;
	float lineMargin = Layout::synthSelectListItemSize + Layout::synthSelectListItemMargin;
	for(int i = 0; i < (int)synths.size(); i++) {
		listy += lineMargin;
		string l = getSynthString(synths.at(i));
		ftlabel *label = FTLabelFactory::getInstance()->simpleLabel(l, x, listy, Layout::synthSelectListItemSize);
		label->setColor(Layout::SynthSelectListColor);
		GlutMain::addUnit(label);
		list.push_back(label);
	}
}

/*!
 * Synth⃊Xg\
 */
inline void SynthSelectLabel::hideList() {
	for(int i = 0; i < (int)list.size(); i++) {
		ftlabel *label = list.at(i);
		new UpdaterKillUnit(label, 1);		// label폜
	}
	list.clear();
}

/*!
 * w肵WXgGA𔻒
 */
inline bool SynthSelectLabel::isListArea(float x, float y) {
	float minx = currentLabel->getX() * GlutMain::width;
	float maxx = minx + currentLabel->getLabelWidth();
	float tmp = currentLabel->getY() * GlutMain::height;
	float miny = tmp - currentLabel->getLabelWidth();
	// XgGAɂsynthSelectListItemMarginԂ]T
	float maxy = tmp + (list.size() * (Layout::synthSelectListItemMargin + Layout::synthSelectListItemSize)
				+ Layout::synthSelectListItemMargin) * GlutMain::height;
	if(minx <= x && x <= maxx && miny <= y && y <= maxy) {
		return true;
	}
	return false;
}

/*!
 * w肵WSynthI
 * ix, yPixellj
 */
void SynthSelectLabel::select(float x, float y)
{
	for(int i = 0; i < (int)list.size(); i++) {
		ftlabel *label = list.at(i);
		if(label->isArea(x, y)) {
			synthManager->setCurrentSynth(i);
		}
	}
}

/*!
 * Synthx̃[I[o[oăXg\
 * ix, yPixellj
 */
void SynthSelectLabel::rollover(float x, float y)
{
	bool over = currentLabel->isArea(x, y);
	if(!listing) {
		if(over) {
			showList();
			listing = true;
		}
	} else {	// listing
		if(isListArea(x, y)) {
			for(int i = 0; i < (int)list.size(); i++) {
				ftlabel *label = list.at(i);
				if(label->isArea(x, y)) {
					label->setColor(Layout::SynthSelectLabelColor);
				} else {
					label->setColor(Layout::SynthSelectListColor);
				}
			}
		} else {
			hideList();
			listing = false;
		}
	}
}
