/*
 * StepPatternDraw.cpp
 *
 *  Created on: 2009/10/07
 *      Author: ox
 */

#include "StepPatternDraw.h"

StepPatternDraw::StepPatternDraw(StepPattern *pattern,
		float x, float y, float size, float rectsRatio, UnitMng *mng) :
	pattern(pattern), x(x), y(y), size(size), rectsRatio(rectsRatio), totalWidth(0), mng(mng)
{
	setPattern(pattern);
}

StepPatternDraw::~StepPatternDraw() {
	clearAll();
}

inline void StepPatternDraw::clearAll() {
	for(unsigned int i = 0; i < stepRects.size(); i++) {
		Rect *rect = stepRects.at(i);
		rect->die();
	}
	stepRects.clear();
}

//! \p^[patternɐ؂ւ
void StepPatternDraw::setPattern(StepPattern *pattern)
{
	clearAll();
	cout << "new Pattern : ";
	for(unsigned int i = 0; i < pattern->getLength(); i++) {
		StepData &data = pattern->at(i);
		Rect *rect = new Rect();
		rect->setAlign(SHAPE_CORNER_LEFT_TOP);
		if(data.value != 0) {
			rect->setFill(true);
			rect->setA(data.value);
			cout << "*";
		} else {
			rect->setVisible(false);
			rect->setFill(false);
			cout << "_";
		}
		mng->addUnit(rect);
		stepRects.push_back(rect);
	}
	cout << endl;
	setRectsSize(size);
	setPos(x, y);
}

bool StepPatternDraw::isArea(float x, float y)
{
//	if((this->x <= x) && (x <= (this->x + totalWidth))) {
	if((this->x <= x) && (x <= (this->x + totalWidth)) &&
			(this->y <= y) && (y <= (this->y + size))) {
		return true;
	}
	return false;
}

void StepPatternDraw::setColor(const Colorful &col) {
	setColor(col.getA(), col.getG(), col.getB(), col.getA());
}

void StepPatternDraw::setColor(float r, float g, float b, float a) {
	for(unsigned int i = 0; i < stepRects.size(); i++) {
		Rect *rect = stepRects.at(i);
		rect->setColor(r, g, b, a);
	}
}

void StepPatternDraw::movey(float my) {
	for(unsigned int r = 0; r < stepRects.size(); r++) {
		Rect *rect = stepRects.at(r);
		rect->setY(rect->getY() + my);
	}
}

void StepPatternDraw::setPos(float x, float y) {
	for(unsigned int i = 0; i < stepRects.size(); i++) {
		Rect *rect = stepRects.at(i);
		rect->setPos(x + (size+rectsMargin) * i, y);
	}
}

void StepPatternDraw::setRectsSize(float size) {
	rectsMargin = size * rectsRatio;
	for(unsigned int i = 0; i < stepRects.size(); i++) {
		Rect *rect = stepRects.at(i);
		StepData &data = pattern->at(i);
		float iDuration = ((int) data.duration);

		if((data.duration != 0) && (iDuration == data.duration)) { iDuration--; }
		rect->setHeight(size);
		rect->setWidth(size * data.duration + iDuration * rectsMargin);
	}
	totalWidth = (size+rectsMargin) * stepRects.size();	// SRectׂ
}
