/*
 * SequencePattern.h
 *
 *  Created on: 2009/10/06
 *      Author: ox
 */

#ifndef SEQUENCEPATTERN_H_
#define SEQUENCEPATTERN_H_

#include <vector>
#include <iostream>
#include <string>

using namespace std;

class StepPattern {
public:
	struct StepData {
		float value;		// default 0=off
		float duration;		// default 1
		float velocity;		// optional
		StepData(float value = 0, float duration = 0, float velocity = 0) :
			value(value), duration(duration), velocity(velocity) {}
	};

	StepPattern(unsigned int length, string name);
	virtual ~StepPattern();

	//! posԖڂ̃Xebvf[^
	void set(unsigned int pos, float value, float duration = 1, float velocity = 0.8);

	//! posԖڂ̃Xebvf[^Q
	StepData &at(unsigned int pos) {
		unsigned int p = pos % length;
		return steps.at(p);
	}

	unsigned int getLength() { return length; }
	string getName() { return name; }

private:
	string name;
	unsigned int length;
	vector<StepData> steps;
};

typedef StepPattern::StepData StepData;

#endif /* SEQUENCEPATTERN_H_ */
