/*
 * SequenceArea.h
 *
 *  Created on: 2009/09/15
 *      Author: sambuichi
 */

#ifndef SEQUENCEAREA_H_
#define SEQUENCEAREA_H_

#include "sound/Sequence.h"

#include "graphic/text/FTLabelFactory.h"
#include "graphic/comp/GridFigure.h"
#include "graphic/comp/InputEvents.h"

class SequenceArea {
public:
	struct Area {
		int maxx;
		int maxy;
		int minx;
		int miny;
		Area() : maxx(0), maxy(0), minx(INT_MAX), miny(INT_MAX) {}
	};

	SequenceArea(GridFigureFactory &figureFactory, Sequence* sequence, InputEvents &inputEvents,
			float width, float height);
	virtual ~SequenceArea();

	void show();

	void hide();

	bool rollover(int x, int y);

	//! SV[PX\𔻒
	bool isShowing() { return sequenceAreaViewing; }

	bool isRollover() { return rollovering; }

private:
	GridFigureFactory &figureFactory;	// `nh
	Sequence* sequence;
	Area area;
	CellFigureHandle *figure;
	ftlabel *label;

	::Mutex areaMapMutex;

	float width;
	float height;
	float width_over;
	float height_over;
	bool sequenceAreaViewing;
	bool rollovering;

	string getAreaString();

	bool isInputArea(int mouseX, int mouseY);

	//! V[PXo^
	void entryInputArea(Sequence *seq, InputEvents &inputEvents);
};

#endif /* SEQUENCEAREA_H_ */
