/*
 * SeqTrajectory.h
 *
 *  Created on: 2009/10/29
 *      Author: ox
 */

#ifndef SEQTRAJECTORY_H_
#define SEQTRAJECTORY_H_

#include "common/Mutex.h"
#include "sound/Sequence.h"
#include "graphic/comp/GridFigure.h"
#include "graphic/comp/InputEvents.h"
#include "graphic/port/Colorful.h"

class SeqTrajectory {
public:
	SeqTrajectory(GridFigureFactory &figureFactory, Sequence *sequence, InputEvents &inputEvents,
			float width, float height);
	virtual ~SeqTrajectory();

	void show();

	void hide();

	void highlight(bool t);

private:
	GridFigureFactory &figureFactory;	// `nh
	Sequence* sequence;			// OՂ`悷ΏۃV[PX
	vector<InputEvent> events;	// V[PXɑΉ̓Cxg
	vector<CellFigureHandle*> figureHandles;	// `IuWFNg
	Mutex figureMutex;

	void drawInputPoint(InputEvent &ie);
	void drawCellLine(InputEvent &ie1, InputEvent &ie2);

	float width;
	float height;
	float width_over;
	float height_over;
	bool showing;		// OՂ`撆ł邱ƂtO

//	Colorful lineColor, rectColor, lineHighColor, rectHighColor;
	Colorful color, highColor;

};

#endif /* SEQTRAJECTORY_H_ */
