/*
 * InputEventToSeqMessage.h
 *
 *  Created on: 2009/10/16
 *      Author: ox
 */

#ifndef INPUTEVENTTOSEQMESSAGE_H_
#define INPUTEVENTTOSEQMESSAGE_H_

#include "graphic/comp/InputEvents.h"
#include "sound/Sequence.h"

class InputEventToSeqMessage {
private:
	float width_over;
	float height_over;

public:
	InputEventToSeqMessage(float width_over, float height_over) :
		width_over(width_over), height_over(height_over) {};

	virtual ~InputEventToSeqMessage();

	void mouseToNote(int x, int y, float time, float duration, int loop, InputEvents &inputEvents, Sequence *seq)
	{
		float nx = x * width_over;
		float ny = y * height_over;
		int note = n2majorNote(ny, 72, 48);
		float velocity = n2float(nx, 60, 127);

		int noteOnID = seq->addNoteOn(note, velocity, time, loop);
		int noteOffID = seq->addNoteOff(noteOnID, time+duration, loop);

		inputEvents.put(noteOnID, INPUT_TYPE_MOUSE, x, y, INPUT_STATE_PRESS, time, duration);
		inputEvents.put(noteOffID, INPUT_TYPE_MOUSE, x, y, INPUT_STATE_RELEASE, time, duration);
	}

	/*!
	 * 0~1K̒l min ~ max ԂIntlɕϊ
	 */
	int n2int(float n, int min, int max) {
		int width = max - min;
		return 	(int)(min + n * width);
	}

	/*!
	 * 0~1K̒l min ~ max ԂIntlɕϊ
	 */
	float n2float(float n, float min, float max) {
		float width = max - min;
		return 	(float)(min + n * width);
	}

	/*!
	 * 0~1K̒l lowNote ~ highNote ԂMajorNotelɕϊ
	 */
	int n2majorNote(float n, int lowNote, int highNote) {
		int note = n2int(n, lowNote, highNote);
		return note2majorNote(note);
	}

	/*!
	 * note̒lMajorXP[lɋz
	 */
	int note2majorNote(int note) {
		int major[7] = {0, 2, 4, 5, 7, 9, 11};
		int octaveNote = (note / 12) * 12;
		float scaleN = (note - octaveNote) / (float)12;	// notẽIN^[uʒũXP[KCfbNX
		int scaleIndex = ((int)(scaleN * 7)) % 7;
		return octaveNote + major[scaleIndex];
	}

};

#endif /* INPUTEVENTTOSEQMESSAGE_H_ */
