/*
 * GridPosCtrl.h
 *
 *  Created on: 2009/11/01
 *      Author: ox
 */

#ifndef GRIDPOSCTRL_H_
#define GRIDPOSCTRL_H_

#include "app/grid/Layout.h"

#include "sound/Synth.h"

#include "graphic/mng/UnitMng.h"
#include "graphic/comp/GirdPositioner.h"
#include "graphic/comp/ListCtrl.h"

class GridPosCtrl {
public:
	GridPosCtrl(UnitMng *mng, GridPositioner &gpos);
	virtual ~GridPosCtrl();

	void press(Synth *synth, int x, int y);
	void position(int x, int y);
	void mouseWheel(int val);

private:
	UnitMng *mng;
	GridPositioner &gpos;

	ListCtrl rowCtrl;
	ListCtrl colCtrl;

	void getSynthParamStr(Synth *synth, unsigned int paramNum, string &str);
	void getSynthParams(Synth *synth, vector<string> &paramStrs);
};

#endif /* GRIDPOSCTRL_H_ */
