/*
 * GridEventDrawer.cpp
 *
 *  Created on: 2009/11/15
 *      Author: ox
 */

#include "GridEventDrawer.h"
#include "Layout.h"
#include "graphic/updater/UpdaterKillUnit.h"
#include "graphic/UnitForm.h"

GridEventDrawer::GridEventDrawer(GridFigureFactory &figureFactory, float width_over, float height_over) :
	figureFactory(figureFactory), width_over(width_over), height_over(height_over),
	cellLineShowDurationRatio(Layout::eventDrawerInputConnectShow),
	cellLineHideDurationRatio(Layout::eventDrawerInputConnectHide),
	cellLineAlpha(Layout::eventDrawerInputConnectAlhpa),
	inputPointDurationRatio(Layout::eventDrawerInputPointDuration),
	inputPointAlpha(Layout::eventDrawerInputPointAlpha)
{
}

GridEventDrawer::~GridEventDrawer() {
}


/*!
 * w肵sNZl܂Cell`
 */
inline void GridEventDrawer::drawInputPoint(InputEvent &ie)
{
	int numFrame = (int)(GlutMain::timeToFrame(ie.duration) * inputPointDurationRatio);
	float alpha = inputPointAlpha;

	UnitForm *handle1 = figureFactory.drawCell(ie.data1, ie.data2, 1, alpha, true);
	UnitForm *handle2 = figureFactory.drawCell(ie.data1, ie.data2, 2, alpha, false);

	handle1->updateDelete(numFrame);
	handle2->updateDelete(numFrame);
}

/*!
 * w肵2_(ie1 -> ie2)Ȃ`
 */
inline void GridEventDrawer::drawCellLine(InputEvent &ie1, InputEvent &ie2)
{
	int numFrameToShow = (int)(GlutMain::timeToFrame(ie2.duration) * cellLineShowDurationRatio);
	int numFrameToHide = (int)(GlutMain::timeToFrame(ie2.duration) * cellLineHideDurationRatio);
	float alpha = cellLineAlpha;

	float nx1 = ie1.data1 * width_over;
	float ny1 = ie1.data2 * height_over;
	float nx2 = ie2.data1 * width_over;
	float ny2 = ie2.data2 * height_over;

	CellFigureHandle *handle = figureFactory.drawConnection(nx1, ny1, nx2, ny2);
	handle->updateAlpha(0, alpha, 0, numFrameToShow);
	handle->updateAlpha(alpha, 0, numFrameToShow, numFrameToHide);
	handle->updateDelete(numFrameToShow + numFrameToHide);

	CellFigureHandle *rectHandle = figureFactory.drawCell(nx1, ny1, 1, alpha, false);
	rectHandle->updateAlpha(0, alpha, 0, numFrameToShow);
	rectHandle->updateAlpha(alpha, 0, numFrameToShow, numFrameToHide);
	rectHandle->updateDelete(numFrameToShow + numFrameToHide);

	cout << "Num Frame To Show : " << numFrameToShow << endl;
	cout << "Num Frame To Hide : " << numFrameToHide << endl;
}

//!
void GridEventDrawer::eventDrawProc(Sequence *seq, Sequence::Message &smsg, InputEvent &event)
{
	printfunc

	if(event.state == INPUT_STATE_PRESS) {
		drawInputPoint(event);

		if(lastInputEventMap.find(seq->getID()) == lastInputEventMap.end()) {	//! SequenceɑΉȑOInputEventȂꍇ

		} else {	//! SequenceɑΉȑOInputEventꍇ
			InputEvent &lastInputEvent = lastInputEventMap[seq->getID()];
			drawCellLine(lastInputEvent, event);	//! ȑO̓͂ƍ̓͂łȂ
		}
		lastInputEventMap[seq->getID()] = event;
	}
}
