unit PlugInMain;

{
	ExternalBoardPlugIn PlugInMain
	ExternalBoardPlugIn p SDK Cu
}

interface

uses
	Windows, SysUtils;

// ===== PlugInSDK API ̐錾
type
	// _E[hǂ
	TDownloadState = (dsWait, dsWork, dsComplete, dsDiffComplete, dsNotModify, dsAbort, dsError);

	// w肵 URL ̃vOCŎ󂯕t邩ǂ
	TAcceptType = (atNoAccept, atBBS, atBoard, atThread);

	// *************************************************************************
	// CreateResultString
	// ߂l PChar ł API ̃mۂ
	// *************************************************************************
	TCreateResultString = function(
		resultStr : string
	) : PChar; stdcall;

	// *************************************************************************
	// DisposeResultString
	// ߂l PChar ł API ̃J
	// *************************************************************************
	TDisposeResultString = procedure(
		resultStr : PChar
	); stdcall;

	// *************************************************************************
	// vO{̂̃o[W擾
	// *************************************************************************
	TVersionInfo = procedure(
		var outAgent		: PChar;	// o[W؊܂܂ȂȖ
		var outMajor		: DWORD;	// W[o[W
		var outMinor		: DWORD;	// }Ci[o[W
		var outRelease	: PChar;	// [XiK
		var outRevision	: DWORD		// rWio[
	); stdcall;

	// *************************************************************************
	// bZ[W\
	// *************************************************************************
	TInternalPrint = procedure(
		inMessage	: PChar	// bZ[W
	); stdcall;

	// *************************************************************************
	// fobObZ[W\
	// *************************************************************************
	TInternalDebugPrint = procedure(
		inMessage	: PChar	// bZ[W
	); stdcall;

	// *************************************************************************
	// InternalDownload
	// w肵 URL _E[hĕԂ
	// *************************************************************************
	TInternalDownload = function(
		inURL							: PChar;			// _E[h URL
		var ioModified		: Double;			// ŌɎ擾
		var outResultData	: PChar;			// _E[hꂽ
		inRangeStart			: DWORD = 0;	// Jnʒu
		inRangeEnd				: DWORD = 0		// Iʒu
	) : Longint; stdcall;							// X|XR[h

	// *************************************************************************
	// InternalPost
	// w肵 URL փf[^𑗐M
	// *************************************************************************
	TInternalPost = function(
		inURL							: PChar;			// M URL
		inSource					: PChar;			// Me
		var outResultData	: PChar				// ԂĂ
	) : Longint; stdcall;							// X|XR[h

	// *************************************************************************
	// InternalAbon
	// Q˂ dat `[Jځ`ɒʂ
	// *************************************************************************
	TInternalAbon = function(
		inDatText : PChar;			// O<>[<>tID<>{<> ō\ꂽs؂eLXg
		inDatPath	: PChar = nil	// dat t@C̃tpX
	) : PChar; stdcall;				// ځ`ς݂ dat `eLXg

  // *************************************************************************
  // Q˂ dat `[Jځ`ɒʂ
  // APX
  // *************************************************************************
  TInternalAbonForOne = function(
      inDatText : PChar;		// O<>[<>tID<>{<>[s] ō\ꂽeLXg
      inDatPath	: PChar;		// dat t@C̃tpX
      inNo : Integer				//vꂽXԍ
  ) : PChar; stdcall;				// ځ`ς݂ dat `eLXg

	// *************************************************************************
	// InternalDat2HTML
	// Q˂ dat ` 1 s HTML ɕϊ
	// *************************************************************************
	TInternalDat2HTML = function(
		inDatRes	: PChar; 			// O<>[<>tID<>{<> ō\ꂽeLXg
		inResNo		: DWORD; 			// Xԍ
		inIsNew		: Boolean			// VXȂ True
	) : PChar; stdcall;				// `ꂽ HTML

	// *************************************************************************
	// AddPlugInMenu
	// vOCj[ɍڂǉ
	// IɃvOC\邽߁A
	// @vOC̃f^b`ɕK RemovePlugInMenu ĂяoĂB
	// *************************************************************************
	TAddPlugInMenu = function(
		inInstance	: DWORD;		// vOC̃nh
		inCaption		: PChar		 	// j[ɕ\镶
	) : HMENU; stdcall;			 	// j[nhAǉɎsꍇ NULL

	// *************************************************************************
	// RemovePlugInMenu
	// vOCj[獀ڂ폜
	// *************************************************************************
	TRemovePlugInMenu = procedure(
		inHandle	: HMENU 			// j[nh
	); stdcall;

var
	CreateResultString	: TCreateResultString;
	DisposeResultString	: TDisposeResultString;
	VersionInfo					: TVersionInfo;
	InternalDownload		: TInternalDownload;
	InternalPrint				: TInternalPrint;
	InternalDebugPrint	: TInternalDebugPrint;
	InternalPost				: TInternalPost;
	InternalAbon				: TInternalAbon;
	InternalAbonForOne	: TInternalAbonForOne;
	InternalDat2HTML		: TInternalDat2HTML;
  AddPlugInMenu				: TAddPlugInMenu;
  RemovePlugInMenu		: TRemovePlugInMenu;

procedure LoadInternalAPI(
	inModule : HMODULE
);

implementation

// *************************************************************************
// PlugInSDK  API 
// *************************************************************************
procedure LoadInternalAPI(
	inModule : HMODULE
);
begin

	// ߂lmۊJ֐
	// ĂяoŃmۂƃobt@I[o[CɂȂĂ͂ȂȂ̂
	// SDK ͊mۂꂽԂ݌v
	CreateResultString := GetProcAddress( inModule, 'CreateResultString' );
	if not Assigned( CreateResultString ) then
		System.ExitCode := 1;
	DisposeResultString := GetProcAddress( inModule, 'DisposeResultString' );
	if not Assigned( DisposeResultString ) then
		System.ExitCode := 1;
	// o[W
	VersionInfo := GetProcAddress( inModule, 'VersionInfo' );
	if not Assigned( VersionInfo ) then
		System.ExitCode := 1;
	// ===== ̑⏕֐
	InternalDownload := GetProcAddress( inModule, 'InternalDownload' );
	if not Assigned( InternalDownload ) then
		System.ExitCode := 1;
	InternalPrint := GetProcAddress( inModule, 'InternalPrint' );						// Ă OK
	InternalDebugPrint := GetProcAddress( inModule, 'InternalDebugPrint' );	// Ă OK
	InternalPost := GetProcAddress( inModule, 'InternalPost' );
	if not Assigned( InternalDownload ) then
		System.ExitCode := 1;
	InternalAbon := GetProcAddress( inModule, 'InternalAbon' );
	if not Assigned( InternalAbon ) then
		System.ExitCode := 1;
	InternalAbonForOne := GetProcAddress( inModule, 'InternalAbonForOne' );
	if not Assigned( InternalAbonForOne ) then
		System.ExitCode := 1;
	InternalDat2HTML := GetProcAddress( inModule, 'InternalDat2HTML' );
	if not Assigned( InternalDat2HTML ) then
		System.ExitCode := 1;
	AddPlugInMenu := GetProcAddress( inModule, 'AddPlugInMenu' );
	if not Assigned( AddPlugInMenu ) then
		System.ExitCode := 1;
	RemovePlugInMenu := GetProcAddress( inModule, 'RemovePlugInMenu' );
	if not Assigned( RemovePlugInMenu ) then
		System.ExitCode := 1;

end;

end.
