unit BoardGroup;

interface

uses
	Windows, SysUtils, Classes, ComCtrls, IniFiles, {HTTPApp,} YofUtils, IdGlobal,
	ExternalBoardManager, ExternalBoardPlugInMain, StrUtils, DateUtils;

type
	//Xg̕\ACeI
	TGikoViewType = (gvtAll, gvtLog, gvtNew, gvtUser);
	//Xg̎擾
	//TGikoListCount = (glc50, glc100, glc200, glc500, glc1000, glcAll);
	//ԍ
	//TGikoRoundNo = (grnNone, grn1, grn2, grn3, grn4, grn5, grnOnce);
	//Xg̏グ
	TGikoAgeSage = (gasNone, gasAge, gasSage, gasNew, gasNull);

{	TFolder = class
	private
		FItemList: TList;	//qACeXg
		FLeaf: Boolean;		//ɃtH_Ƃo邩
	public
		function Add(Item: TFolder): Integer;
		procedure Clear;
		procedure Delete(Index: Integer);
		procedure Exchange(Index1, Index2: Integer);
		procedure Insert(Index: Integer; Item: TFolder);
		procedure Move(CurIndex, NewIndex: Integer);
		function Remove(Item: TFolder): Integer;
		procedure Sort(Compare: TListSortCompare);
		property Capacity: Integer read FCapacity write SetCapacity;
		property Count: Integer read FCount write SetCount;
		property Items[Index: Integer]: TFolder read Get write Put; default;

		property Leaf: Boolean read FLeaf;
	end;

	TBBS = class(TFolder)
	end;
	TCategory class(TFolder)
	end;
	TBoard = class(TFolder)
	end;
	TThreadItem = class(TFolder)
	end;
}

{
	TBBS = class(TBBS)
	end;
	TBoard2ch = class(TBoard)
	end;
	TThreadItem2ch = class(TThreadItem)
	end;
}

//	ITest = interface
//	end;
//	IBBS = interface
//	end;
//	ICategory = interface
//	end;
//	IBoard = interface
//	end;
//	IThreadItem = interface
//	end;

	TCategory = class;
	TBoard = class;
	TThreadItem = class;

	// BBS ̃[g
	TBBS = class(TList)
	private
		FTitle: string;
		FFilePath : string;						// Xg̃pX
		FExpand: Boolean;
		FKubetsuChk: Boolean;					//iݎ啶
		FSelectText: string;					//iݕ
		FShortSelectText: string;
		FIsBoardFileRead : Boolean;		// Xg͓ǂݍ܂Ă邩H

		function GetCategory(index: integer): TCategory;
		procedure SetCategory(index: integer; value: TCategory);
		procedure SetSelectText(s: string);
	public
		constructor Create( boardFilePath : string );
		destructor Destroy; override;

		function Add(item: TCategory): integer;
		procedure Delete(index: integer);
		procedure Clear; override;
		function Find(key: string): TCategory;
		function FindBBSID(const BBSID: string): TBoard;
		function FindBoardFromTitle(const Title: string): TBoard;
		function FindBoardFromURL(const inURL: string): TBoard;
		function FindThreadFromURL(const inURL : string ) : TThreadItem;
		function FindThreadItem(const BBSID, FileName: string): TThreadItem;
		function FindCategoryFromTitle(const inTitle : string ) : TCategory;
		property FilePath : string read FFilePath write FFilePath;

		property Items[index: integer]: TCategory read GetCategory write SetCategory;
		property Title: string read FTitle write FTitle;
		property NodeExpand: Boolean read FExpand write FExpand;

		property KubetsuChk: Boolean read FKubetsuChk write FKubetsuChk;
		property SelectText: string read FSelectText write SetSelectText;
		property ShortSelectText: string read FShortSelectText write FShortSelectText;

		property	IsBoardFileRead : Boolean read FIsBoardFileRead write FIsBoardFileRead;
	end;

	// JeS( URL ̃Xg)
//	TCategory = class(THashedStringList)
	TCategory = class(TStringList)
	private
		FNo: Integer;
		FTitle: string;
		FParenTBBS: TBBS;
		FExpand: Boolean;

		function GetBoard(index: integer): TBoard;
		procedure SetBoard(index: integer; value: TBoard);
	public
		constructor Create;
		destructor Destroy; override;

		property No: Integer read FNo write FNo;
		property Title: string read FTitle write FTitle;
		property Items[index: integer]: TBoard read GetBoard write SetBoard;
		property ParenTBBS: TBBS read FParenTBBS write FParenTBBS;

		function Add(item: TBoard): integer;
		procedure Delete(index: integer);
		procedure Clear; override;
		function FindName(const key: string): TBoard;
		function FindBBSID(const BBSID: string): TBoard;
		function FindBoardFromTitle(const Title: string): TBoard;
		function FindBoardFromURL(const inURL: string): TBoard;
		function FindThreadFromURL(const inURL : string ) : TThreadItem;
		function IsMidoku: Boolean;

		property NodeExpand: Boolean read FExpand write FExpand;
	end;

	// (Xbh URL ̃Xg)
//	TBoard = class(THashedStringList)
	TBoard = class(TStringList)
	private
		FContext: DWORD;							// vOCRɐݒ肵Ăl(ɃCX^X)

		FNo: Integer;									//ԍ
		FTitle: string;								//{[h^Cg
		FBBSID: string;								//BBSID
		FURL: string;									//{[hURL
		FRound: Boolean;							//Xbhꗗ\
		FRoundName: string;						//
		FRoundDate: TDateTime;				//Xbhꗗ擾ij
		FLastModified: TDateTime;			//XbhꗗXVĂiT[oj
		FLastGetTime: TDateTime;			//Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
		FIsThreadDatRead: Boolean;		//XbhXg͓ǂݍ܂Ă邩H
		FUnRead: Integer;							//Xbhǐ
		FParentCategory: TCategory;		//eJeS
		FModified: Boolean;						//CtO
		FBoolData: Boolean;						//ȗprɎgyo
		FSPID: string;								//ݗpSPID
		FPON: string;									//ݗpPON
		FKotehanName: string;					//RenO
		FKotehanMail: string;					//Ren[

		FUpdate: Boolean;
		FExpand: Boolean;

		FBoardPlugIn	: TBoardPlugIn;	// ̔T|[gvOC
		FFilePath			: string;				// ̃XꗗۑĂpX
		FIsLogFile		: Boolean;			// O݃tO
		FIntData			: Integer;			// DɂĂ悵BȗprɎgyo
		FListData			: TList;				// DɂĂ悵BȗprɎgyo

		FSETTINGTXTTime: TDateTime;	//SETTING.TXT擾
		FIsSETTINGTXT:		boolean;	//SETTING.TXT擾Ă邩
		FHEADTXTTime: TDateTime;		//HEAD.TXT擾
		FIsHEADTXT:		boolean;	//HEAD.TXT擾Ă邩
        FTitlePictureURL:	string;	//topGURL
		FMultiplicity : Integer; //dĂ邩ǂH
		function GetThreadItem(index: integer): TThreadItem;
		procedure SetThreadItem(index: integer; value: TThreadItem);
		procedure SetRound(b: Boolean);
		procedure SetRoundName(s: string);
		procedure SetLastModified(d: TDateTime);
		procedure SetLastGetTime(d: TDateTime);
		procedure SetUnRead(i: Integer);
		procedure SetKotehanName(s: string);
		procedure SetKotehanMail(s: string);
		procedure Init;
	public
		constructor Create( inPlugIn : TBoardPlugIn; inURL : string );
		destructor Destroy; override;

		property Context: DWORD read FContext write FContext;

		property Items[index: integer]: TThreadItem read GetThreadItem write SetThreadItem;
		property No: Integer read FNo write FNo;
		property Title: string read FTitle write FTitle;
		property BBSID: string read FBBSID write FBBSID;
		property URL: string read FURL write FURL;
		property Round: Boolean read FRound write SetRound;
		property RoundName: string read FRoundName write SetRoundName;
		property RoundDate: TDateTime read FRoundDate write FRoundDate;
		property LastModified: TDateTime read FLastModified write SetLastModified;
		property LastGetTime: TDateTime read FLastGetTime write SetLastGetTime;
		property UnRead: Integer read FUnRead write SetUnRead;
		property Modified: Boolean read FModified write FModified;
		property IsThreadDatRead: Boolean read FIsThreadDatRead write FIsThreadDatRead;
		property ParentCategory: TCategory read FParentCategory write FParentCategory;

		property	BoardPlugIn	: TBoardPlugIn	read FBoardPlugIn;
		property	FilePath		: string				read FFilePath write FFilePath;
		property	IsLogFile		: Boolean				read FIsLogFile write FIsLogFile;
		property	IntData			: Integer				read FIntData write FIntData;
		property	ListData		: TList					read FListData write FListData;
		function	IsBoardPlugInAvailable : Boolean;

		function Add(item: TThreadItem): integer;
		procedure Insert(Index: Integer; Item: TThreadItem);
		procedure Delete(index: integer);
		procedure DeleteList(index: integer);
		procedure Clear; override;
		function FindThreadFromFileName(const ItemFileName: string): TThreadItem;
		function FindThreadFromURL(const inURL : string ) : TThreadItem;
		function GetIndexFromFileName(const ItemFileName: string): Integer;
		function GetIndexFromURL(const URL: string): Integer;
		procedure LoadSettings;
		procedure SaveSettings;
		function GetReadCgiURL: string;
		function GetSubjectFileName: string;
		function GetFolderIndexFileName: string;
		function GetSETTINGTXTFileName: string;
		function GETHEADTXTFileName: string;
		function GetTitlePictureFileName: string;
		function GetSendURL: string;

		function GetNewThreadCount: Integer;
		function GetLogThreadCount: Integer;
		function GetUserThreadCount: Integer;
		function GetNewThread(Index: Integer): TThreadItem;
		function GetLogThread(Index: Integer): TThreadItem;
		function GetUserThread(Index: Integer): TThreadItem;

		procedure BeginUpdate;
		procedure EndUpdate;
		property NodeExpand: Boolean read FExpand write FExpand;
		property BoolData: Boolean read FBoolData write FBoolData;
		property SPID: string read FSPID write FSPID;
		property PON: string read FPON write FPON;
		property KotehanName: string read FKotehanName write SetKotehanName;
		property KotehanMail: string read FKotehanMail write SetKotehanMail;

		property SETTINGTXTTime: TDateTime read FSETTINGTXTTime write FSETTINGTXTTime;
		property IsSETTINGTXT:	boolean read FIsSETTINGTXT write FIsSETTINGTXT;
		property HEADTXTTime: TDateTime read FHEADTXTTime write FHEADTXTTime;
		property IsHEADTXT:	boolean read FIsHEADTXT write FIsHEADTXT;
        property TitlePictureURL: string read FTitlePictureURL write FTitlePictureURL;
		property Multiplicity: Integer read FMultiplicity write FMultiplicity;
	end;

	//X
	TThreadItem = class(TObject)
	private
		FContext: DWORD;					// vOCRɐݒ肵Ăl(ɃCX^X)

		FNo: Integer;							//ԍ
		FFileName: string;				//Xbht@C
		FTitle: string;						//Xbh^Cg
		FShortTitle: string;			//ZXbh^Cgipj
		FRoundDate: TDateTime;		//Xbh擾ij
		FLastModified: TDateTime; //XbhXVĂiT[oj
		FCount: Integer;					//XbhJEgi[Jj
		FAllResCount: Integer;		//XbhJEgiT[oj
		FNewResCount: Integer;		//XbhV
		FSize: Integer;						//XbhTCY
		FRound: Boolean;					//tO
		FRoundName: string;				//
		FIsLogFile: Boolean;			//O݃tO
		FParentBoard: TBoard;			//e{[h
		FKokomade: Integer;				//RR܂œǂ񂾔ԍ
		FNewReceive: Integer; 		//RRVKM
		FNewArrival: Boolean;			//V
		FUnRead: Boolean;					//ǃtO
		FScrollTop: Integer;			//XN[ʒu
		FDownloadHost: string;		//̃zXgƈႤꍇ̃zXg
		FAgeSage: TGikoAgeSage;		//ACȅグ
//		FSPID: string;						//ݗpSPID

		FUpdate: Boolean;
		FExpand: Boolean;
		FURL					: string;				// ̃XuEUŕ\ۂ URL
		FBoardPlugIn	: TBoardPlugIn;	// ̃XT|[gvOC
		FFilePath			: string;				// ̃XۑĂpX

		procedure SetLastModified(d: TDateTime);
		procedure SetRound(b: Boolean);
		procedure SetRoundName(const s: string);
		procedure SetKokomade(i: Integer);
		procedure SetUnRead(b: Boolean);
		procedure SetScrollTop(i: Integer);
		procedure Init;
		function GetCreateDate: TDateTime;
	public
		constructor Create( inPlugIn : TBoardPlugIn; inURL : string ); overload;
        constructor Create( is2ch : Boolean; const inURL, inHost, inBBSID, inBBSKey : string ); overload;

		destructor Destroy; override;

		function GetDatURL: string;
		function GetDatgzURL: string;
//		function GetOldDatgzURL: string;
		function GetOfflawCgiURL(const SessionID: string): string;
		function GetSendURL: string;
		procedure DeleteLogFile;
		function GetThreadFileName: string;
		procedure BeginUpdate;
		procedure EndUpdate;

		property Context: DWORD read FContext write FContext;

		property No: Integer read FNo write FNo;
		property FileName: string read FFileName write FFileName;
		property Title: string read FTitle write FTitle;
		property ShortTitle: string read FShortTitle write FShortTitle;
		property RoundDate: TDateTime read FRoundDate write FRoundDate;
		property LastModified: TDateTime read FLastModified write SetLastModified;
		property Count: Integer read FCount write FCount;
		property AllResCount: Integer read FAllResCount write FAllResCount;
		property NewResCount: Integer read FNewResCount write FNewResCount;
		property Size: Integer read FSize write FSize;
		property Round: Boolean read FRound write SetRound;
		property RoundName: string read FRoundName write SetRoundName;

		property IsLogFile: Boolean read FIsLogFile write FIsLogFile;
		property ParentBoard: TBoard read FParentBoard write FParentBoard;
		property Kokomade: Integer read FKokomade write SetKokomade;
		property NewReceive: Integer read FNewReceive write FNewReceive;
		property NewArrival: Boolean read FNewArrival write FNewArrival;
		property UnRead: Boolean read FUnRead write SetUnRead;
		property ScrollTop: Integer read FScrollTop write SetScrollTop;
		property Expand: Boolean read FExpand write FExpand;
		property DownloadHost: string read FDownloadHost write FDownloadHost;
		property AgeSage: TGikoAgeSage read FAgeSage write FAgeSage;
//		property SPID: string read FSPID write FSPID;
		property CreateDate: TDateTime read GetCreateDate;
		property	URL					: string				read FURL write FURL;
		property	BoardPlugIn	: TBoardPlugIn	read FBoardPlugIn;
		property	FilePath		: string				read FFilePath write FFilePath;
		function	IsBoardPlugInAvailable : Boolean;
	end;



	//ʃXg
{	TSearchList = class(TList)
	private
		function GetThreadItem(index: integer): TThreadItem;
		procedure SetThreadItem(index: integer; value: TThreadItem);
	public
		constructor Create;
		destructor Destroy; override;

		property Items[index: integer]: TThreadItem read GetThreadItem write SetThreadItem;

		function Add(item: TThreadItem): integer;
		procedure Delete(index: integer);
		procedure Clear; override;
	end;}

	function	BBSsFindBoardFromBBSID( inBBSID : string ) : TBoard;
	function	BBSsFindBoardFromURL( inURL : string ) : TBoard;
	function	BBSsFindBoardFromTitle( inTitle : string ) : TBoard;
	function	BBSsFindThreadFromURL(const inURL : string ) : TThreadItem;
	function	ConvertDateTimeString( inDateTimeString : string) : TDateTime;

var
	BBSs 		: array of TBBS;

implementation

uses
	GikoSystem, RoundData, MojuUtils;

const
	BBS2CH_NAME:					 string	= 'Q˂';
	BBS2CH_LOG_FOLDER:		 string	= '2ch';
	EXTERNAL_LOG_FOLDER:		string	= 'exboard';

	FOLDER_INI_FILENAME:	 string	= 'Folder.ini';
	FOLDER_INDEX_FILENAME: string	= 'Folder.idx';
	SUBJECT_FILENAME:			string	= 'subject.txt';
	PATH_DELIM:						string	= '\';
	SETTINGTXT_FILENAME:		string = 'SETTING.TXT';
    HEADTXT_FILENAME:		string = 'head.html';
	//DEFAULT_LIST_COUNT:		Integer = 100;

//	COLUMN_CATEGORY:	 array[0..0] of string = ('JeS');
//	COLUMN_BOARD:			array[0..3] of string = ('', '擾', '\', 'O񏄉');
//	COLUMN_THREADITEM: array[0..3] of string = ('Xbh', 'JEg', '\', 'O񏄉');

// BBSID p 2 ˂̂ݒTo܂
// BBSID ̎gp͋ɗ͔ĂB
// \ȏꍇ URL gpĂB
function	BBSsFindBoardFromBBSID(
	inBBSID	: string
) : TBoard;
begin

	Result := BBSs[ 0 ].FindBBSID( inBBSID );

end;

function	BBSsFindBoardFromURL(
	inURL	: string
) : TBoard;
var
	i			: Integer;
begin

	for i := Length( BBSs ) - 1 downto 0 do begin
		Result := BBSs[ i ].FindBoardFromURL( inURL );
		if Result <> nil then
			Exit;
	end;

	Result := nil;

end;

function	BBSsFindBoardFromTitle(
	inTitle	: string
) : TBoard;
var
	i				: Integer;
begin

	for i := Length( BBSs ) - 1 downto 0 do begin
		Result := BBSs[ i ].FindBoardFromTitle( inTitle );
		if Result <> nil then
			Exit;
	end;

	Result := nil;

end;

function	BBSsFindThreadFromURL(
	const inURL			: string
) : TThreadItem;
var
	board			: TBoard;
	boardURL	: string;
begin

	boardURL	:= GikoSys.GetThreadURL2BoardURL( inURL );
	board			:= BBSsFindBoardFromURL( boardURL );
	if board = nil then
		Result := nil
	else
		Result := board.FindThreadFromURL( inURL );

end;

(*************************************************************************
 *@\FTBBSRXgN^
 *Public
 *************************************************************************)
constructor TBBS.Create( boardFilePath : string );
begin
	inherited Create;
	Title := BBS2CH_NAME;
	FFilePath := boardFilePath;
end;

(*************************************************************************
 *@\FTBBSfXgN^
 *Public
 *************************************************************************)
destructor TBBS.Destroy;
begin
	Clear;
	inherited;
end;

(*************************************************************************
 *@\F
 *Public
 *************************************************************************)
function TBBS.GetCategory(index: integer): TCategory;
begin
	Result := TCategory(inherited Items[index]);
end;

procedure TBBS.SetCategory(index: integer; value: TCategory);
begin
	inherited Items[index] := value;
end;

function TBBS.Add(item: TCategory): integer;
begin
	Item.ParenTBBS := self;
	Result := inherited Add(item);
end;

procedure TBBS.Delete(index: integer);
begin
	if Items[index] <> nil then
		TCategory(Items[index]).Free;
	Items[index] := nil;
	inherited Delete(index);
end;

procedure TBBS.Clear;
var
	i: integer;
begin
	for i := Count - 1 downto 0 do
		Delete(i);
    Capacity := Count;
end;

function TBBS.Find(key: string): TCategory;
begin
	Result := nil;
end;

function TBBS.FindBBSID(const BBSID: string): TBoard;
var
	i	: Integer;
begin
	if not IsBoardFileRead then
  	GikoSys.ReadBoardFile( Self );
	for i := Count - 1 downto 0 do begin
		Result := Items[ i ].FindBBSID(BBSID);
		if Result <> nil then
			Exit;
	end;
	Result := nil;
end;

//*************************************************************************
// ^Cg̈vT
//*************************************************************************)
function TBBS.FindBoardFromTitle(const Title: string): TBoard;
var
	i: Integer;
begin
	if not IsBoardFileRead then
  	GikoSys.ReadBoardFile( Self );
	for i := Count - 1 downto 0 do begin
		Result := Items[ i ].FindBoardFromTitle(Title);
		if Result <> nil then
			Exit;
	end;
	Result := nil;
end;

//*************************************************************************
// URL 󂯕tT
//*************************************************************************)
function TBBS.FindBoardFromURL(const inURL: string): TBoard;
var
	i					: Integer;
begin
	if not IsBoardFileRead then
  	GikoSys.ReadBoardFile( Self );
	for i := Count - 1 downto 0 do begin
		Result := Items[ i ].FindBoardFromURL( inURL );
		if Result <> nil then
			Exit;
	end;
	Result := nil;
end;

//*************************************************************************
// URL 󂯕tXbhT
//*************************************************************************)
function TBBS.FindThreadFromURL(const inURL: string): TThreadItem;
var
	board			: TBoard;
	boardURL	: string;
begin

	boardURL	:= GikoSys.GetThreadURL2BoardURL( inURL );
	board			:= FindBoardFromURL( boardURL );
	if board = nil then
		Result := nil
	else
		Result := board.FindThreadFromURL( inURL );

end;

function TBBS.FindThreadItem(const BBSID, FileName: string): TThreadItem;
var
	Board: TBoard;
begin
	Result := nil;
	Board := FindBBSID(BBSID);
	if Board = nil then
		Exit;
	Result := Board.FindThreadFromFileName(FileName);
end;

function TBBS.FindCategoryFromTitle(const inTitle : string ) : TCategory;
var
	i : Integer;
begin

	for i := Count - 1 downto 0 do begin
		if AnsiCompareStr(Items[ i ].Title, inTitle) = 0 then begin
			Result := Items[ i ];
			Exit;
		end;
	end;

	Result := nil;

end;

procedure TBBS.SetSelectText(s: string);
begin
	FSelectText := s;
	ShortSelectText := CustomStringReplace(ZenToHan(s), ' ', '');
end;

{class function TBBS.GetColumnName(Index: Integer): string;
begin
	Result := COLUMN_CATEGORY[Index];
end;

class function TBBS.GetColumnCount: Integer;
begin
	Result := Length(COLUMN_CATEGORY);
end;}

//===================
//TCategory
//===================
constructor TCategory.Create;
begin
	inherited;

	Duplicates		:= dupIgnore;
	CaseSensitive	:= False;
	//Sorted				:= True;
end;

destructor TCategory.Destroy;
begin
	Clear;
	inherited;
end;

function TCategory.GetBoard(index: integer): TBoard;
begin
	Result := TBoard( Objects[index] );
end;

procedure TCategory.SetBoard(index: integer; value: TBoard);
begin
	Objects[index] := value;
	Strings[index] := value.URL
end;

function TCategory.Add(item: TBoard): integer;
begin
	Item.ParentCategory := self;
	Result := AddObject( item.URL, item );
end;

procedure TCategory.Delete(index: integer);
begin
	if (Items[index] <> nil) then begin
		try
			if TBoard(Items[index]).Multiplicity = 0 then
				TBoard(Items[index]).Free
			else
				TBoard(Items[index]).Multiplicity := TBoard(Items[index]).Multiplicity - 1;
		except
		end;
	end;
	inherited Delete(index);
end;

procedure TCategory.Clear;
var
	i: integer;
begin
	for i := Count - 1 downto 0 do
		Delete(i);
	Capacity := Count;
end;

function TCategory.FindName(const key: string): TBoard;
begin
	Result := nil;
end;

function TCategory.FindBBSID(const BBSID: string): TBoard;
var
	i	: integer;
begin
	for i := Count - 1 downto 0 do begin
		if AnsiCompareStr(Items[i].FBBSID, BBSID) = 0 then begin
			Result := Items[i];
			Exit;
		end;
	end;
	Result := nil;
end;

//*************************************************************************
// ^Cg̈vT
//*************************************************************************)
function TCategory.FindBoardFromTitle(const Title: string): TBoard;
var
	i	: integer;
begin
	for i := Count - 1 downto 0 do begin
		if AnsiCompareStr(Items[i].FTitle, Title) = 0 then begin
			Result := Items[i];
			Exit;
		end;
	end;
	Result := nil;
end;

//*************************************************************************
// URL 󂯕tT
//*************************************************************************)
function TCategory.FindBoardFromURL(const inURL: string): TBoard;
var
	i	: Integer;
begin
	i := IndexOf( inURL );
	if i >= 0 then
		Result := TBoard( Objects[ i ] )
	else
		Result := nil;
end;

//*************************************************************************
// URL 󂯕tXbhT
//*************************************************************************)
function TCategory.FindThreadFromURL(const inURL: string): TThreadItem;
var
	board			: TBoard;
	boardURL	: string;
begin

	boardURL	:= GikoSys.GetThreadURL2BoardURL( inURL );
	board			:= FindBoardFromURL( boardURL );
	if board = nil then
		Result := nil
	else
		Result := board.FindThreadFromURL( inURL );

end;

function TCategory.IsMidoku: Boolean;
var
	i: Integer;
	j: Integer;
begin
	Result := False;
	for i := 0 to Count - 1 do begin
		if Items[i] <> nil then begin
			for j := 0 to Items[i].Count - 1 do begin
				if Items[i].Items[j] <> nil then begin
//					if (Items[i].Items[j].IsLogFile) and (Items[i].Items[j].Count > Items[i].Items[j].Kokomade) then begin
					if (Items[i].Items[j].IsLogFile) and (Items[i].Items[j].UnRead) then begin
						Result := True;
						Exit;
					end;
				end;
			end;
		end;
	end;
end;

{class function TCategory.GetColumnName(Index: Integer): string;
begin
	Result := COLUMN_BOARD[Index];
end;

class function TCategory.GetColumnCount: Integer;
begin
	Result := Length(COLUMN_BOARD);
end;}

//===================
//TBoard
//===================
procedure TBoard.Init;
begin
	Duplicates		:= dupIgnore;
	CaseSensitive	:= False;
	//Sorted				:= True;

	FNo := 0;
	FTitle := '';
	FBBSID := '';
	FURL := '';
	FRound := False;
	FRoundDate := ZERO_DATE;
	FLastModified := ZERO_DATE;
	FLastGetTime := ZERO_DATE;
	FIsThreadDatRead := False;
	FUnRead := 0;
//	FListStyle := vsReport;
//	FItemNoVisible := True;

	FUpdate := True;
end;

// *************************************************************************
// OvOCw肵RXgN^
// *************************************************************************
constructor TBoard.Create(
	inPlugIn	: TBoardPlugIn;
	inURL			: string
);
var
	protocol, host, path, document, port, bookmark	: string;
begin

	inherited Create;
	Init;

	FBoardPlugIn	:= inPlugIn;
	URL						:= inURL;
	BBSID					:= GikoSys.UrlToID( inURL );

	if inPlugIn = nil then begin
		// subject.txt ̕ۑpXݒ
		GikoSys.ParseURI( inURL, protocol, host, path, document, port, bookmark );
		if GikoSys.Is2chHost( host ) then
			FilePath :=
				GikoSys.Setting.LogFolderP  +
				BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + SUBJECT_FILENAME
		else
			FilePath :=
				GikoSys.Setting.LogFolderP +
				EXTERNAL_LOG_FOLDER + PATH_DELIM + host + PATH_DELIM + BBSID + PATH_DELIM + SUBJECT_FILENAME
	end else begin
		// vOC TBoardItem 쐬ꂽƂ`
		inPlugIn.CreateBoardItem( DWORD( Self ) );
	end;

end;

// *************************************************************************
// fXgN^
// *************************************************************************
destructor TBoard.Destroy;
begin
	if FModified then begin
		GikoSys.WriteThreadDat(Self);
		SaveSettings;
	end;

	// vOC TBoardItem jꂽƂ`
	if IsBoardPlugInAvailable then
		BoardPlugIn.DisposeBoardItem( DWORD( Self ) );

	Clear;
	inherited;
end;

// *************************************************************************
// OvOCgp\
// *************************************************************************
function	TBoard.IsBoardPlugInAvailable : Boolean;
begin

	repeat
		if BoardPlugIn = nil then
			Break;
			
		if not Assigned( Pointer( BoardPlugIn.Module ) ) then
			Break;

		Result := True;
		Exit;
	until True;

	Result := False;

end;

function TBoard.GetThreadItem(index: integer): TThreadItem;
begin
	Result := TThreadItem( Objects[index] );
end;

procedure TBoard.SetThreadItem(index: integer; value: TThreadItem);
begin
	Objects[index] := value;
	Strings[index] := value.URL;
end;

function TBoard.Add(Item: TThreadItem): Integer;
begin
	Item.ParentBoard := Self;
	Result := inherited AddObject(Item.URL, Item);
end;

procedure TBoard.Insert(Index: Integer; Item: TThreadItem);
begin
	Item.ParentBoard := Self;
	inherited InsertObject(Index, Item.URL, Item);

end;

//IndexŎw肳ꂽXbhIuWFNgj
procedure TBoard.Delete(index: Integer);
begin
	if Items[index] <> nil then
		TThreadItem(Items[index]).Free;
	inherited Delete(index);
end;

//IndexŎw肳ꂽXbhXg폜iXIuWFNg͂̂j
procedure TBoard.DeleteList(index: integer);
begin
	inherited Delete(index);
end;

procedure TBoard.Clear;
var
	i: integer;
begin
//	FUnRead := 0;
	for i := Count - 1 downto 0 do
		Delete(i);
	 Capacity := Count;
end;

function TBoard.FindThreadFromFileName(const ItemFileName: string): TThreadItem;
var
	i: integer;
begin
	Result := nil;
	for i := 0 to Count - 1 do begin
		if AnsiCompareStr(Items[i].FileName, ItemFileName) = 0 then begin
			Result := Items[i];
			Exit;
		end;
	end;
end;

function TBoard.GetIndexFromFileName(const ItemFileName: string): Integer;
var
	i: integer;
begin
	Result := -1;
	for i := 0 to Count - 1 do begin
		if Items[i].FileName = ItemFileName then begin
			Result := i;
			Exit;
		end;
	end;
end;

function TBoard.GetIndexFromURL(const URL: string): Integer;
begin
	Result := IndexOf( URL );
end;

function TBoard.FindThreadFromURL(const inURL : string ) : TThreadItem;
var
	i : Integer;
begin

	if not IsThreadDatRead then
		GikoSys.ReadSubjectFile( Self );

	i := IndexOf( inURL );
	if i >= 0 then
		Result := TThreadItem( Objects[ i ] )
	else
		Result := nil;

end;

{function TBoard.GetMidokuCount: Integer;
var
	i: integer;
begin
	Result := 0;
	for i := 0 to Count- 1 do begin
		if Items[i] <> nil then begin
			if (Items[i].IsLogFile) and (Items[i].Count > Items[i].Kokomade) then
				inc(Result);
		end;
	end;
end;
}

procedure TBoard.LoadSettings;
var
	ini: TMemIniFile;
	FileName: string;
	tmp: string;
begin
	if Length( FilePath ) > 0 then
		FileName := ExtractFilePath( FilePath ) + FOLDER_INI_FILENAME
	else
		FileName := GikoSys.Setting.LogFolderP
							+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + FOLDER_INI_FILENAME;

	if not FileExists(FileName) then
		Exit;
	ini := TMemIniFile.Create(FileName);
	try
//		Round := ini.ReadBool('Status', 'Round', False);
		tmp := ini.ReadString('Status', 'RoundDate', DateTimeToStr(ZERO_DATE));
		FRoundDate := ConvertDateTimeString(tmp);
		tmp := ini.ReadString('Status', 'LastModified', DateTimeToStr(ZERO_DATE));
		FLastModified := ConvertDateTimeString(tmp);
		tmp := ini.ReadString('Status', 'LastGetTime', DateTimeToStr(ZERO_DATE));
		FLastGetTime := ConvertDateTimeString(tmp);

		tmp := ini.ReadString('BoardInformation', 'SETTINGTXTTime', DateTimeToStr(ZERO_DATE));
		FSETTINGTXTTime := ConvertDateTimeString(tmp);
		tmp := ini.ReadString('BoardInformation', 'HEADTXTTime', DateTimeToStr(ZERO_DATE));
		FHEADTXTTime := ConvertDateTimeString(tmp);

		FIsSETTINGTXT := ini.ReadBool('BoardInformation', 'IsSETTINGTXT', false);
		FIsHEADTXT := ini.ReadBool('BoardInformation', 'IsHEADTXT', false);
		FTitlePictureURL := ini.ReadString('BoardInformation', 'TitlePictureURL', '');

		FUnRead := ini.ReadInteger('Status', 'UnRead', 0);
		FSPID := ini.ReadString('Cookie', 'SPID', '');
		FPON := ini.ReadString('Cookie', 'PON', '');
		FKotehanName := ini.ReadString('Kotehan', 'Name', '');
		FKotehanMail := ini.ReadString('Kotehan', 'Mail', '');

		if UnRead < 0 then
			UnRead := 0;
	finally
		ini.Free;
	end;
end;

procedure TBoard.SaveSettings;
var
	ini: TMemIniFile;
	FileName: string;
begin
	if Length( FilePath ) > 0 then
		FileName := ExtractFilePath( FilePath )
	else
		FileName := GikoSys.Setting.LogFolderP
							+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM;
	if not GikoSys.DirectoryExistsEx(FileName) then
		GikoSys.ForceDirectoriesEx(FileName);
	FileName := FileName + FOLDER_INI_FILENAME;
	ini := TMemIniFile.Create(FileName);
	try
		if UnRead < 0 then
			UnRead := 0;
//		ini.WriteBool('Status', 'Round', Round);
		ini.WriteDateTime('Status', 'RoundDate', FRoundDate);
		ini.WriteDateTime('Status', 'LastModified', FLastModified);
		ini.WriteDateTime('Status', 'LastGetTime', FLastGetTime);
		ini.WriteInteger('Status', 'UnRead', FUnRead);
		ini.WriteString('Cookie', 'SPID', FSPID);
		ini.WriteString('Cookie', 'PON', FPON);
		ini.WriteString('Kotehan', 'Name', FKotehanName);
		ini.WriteString('Kotehan', 'Mail', FKotehanMail);

		ini.WriteDateTime('BoardInformation', 'SETTINGTXTTime', FSETTINGTXTTime);
		ini.WriteDateTime('BoardInformation', 'HEADTXTTime', FHEADTXTTime);

		ini.WriteBool('BoardInformation', 'IsSETTINGTXT', FIsSETTINGTXT);
		ini.WriteBool('BoardInformation', 'IsHEADTXT', FIsHEADTXT);
		ini.WriteString('BoardInformation', 'TitlePictureURL', FTitlePictureURL);
//		ini.WriteInteger('Status', 'ListStyle', Ord(ListStyle));
//		ini.WriteBool('Status', 'ItemNoVisible', ItemNoVisible);
//		ini.WriteInteger('Status', 'ViewType', Ord(ViewType));
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;
//Ƃ2003 02 08 0:32:13Ȍ`̓t̂ł
//        2003/02/08 0:32:13ɕϊ
function	ConvertDateTimeString( inDateTimeString : string) : TDateTime;
const
	ZERO_DATE_STRING : string = '1970/01/01 0:00:00';
var
	i : Integer;
    y: Integer;
    m: Integer;
    d: Integer;
    hour: Integer;
    min: Integer;
    sec: Integer;
begin
    if inDateTimeString = '' then
    	inDateTimeString := ZERO_DATE_STRING;

    if ( AnsiPos('/', inDateTimeString ) = 0 ) and
    	( AnsiCompareStr( DateTimeToStr(ZERO_DATE), inDateTimeString) <> 0 ) then begin
		for i := 0 to 1 do begin
    		Insert('/',inDateTimeString, AnsiPos(' ', inDateTimeString) + 1 );
        	Delete(inDateTimeString, AnsiPos(' ', inDateTimeString), 1);
    	end;
    end;
    try
    	Result := StrToDateTime( inDateTimeString );
    except
    	if( inDateTimeString[5] = '/' ) and ( inDateTimeString[8] = '/' ) then begin
            y := StrToIntDef( Copy(inDateTimeString, 1, 4), 1970 );
			m := StrToIntDef( Copy(inDateTimeString, 6, 2), 1 );
            d := StrToIntDef( Copy(inDateTimeString, 9, 2), 1 );
            hour := 0; min  := 0; sec  := 0;

        	if Length(inDateTimeString) > 11 then begin
            	if( inDateTimeString[13] = ':' ) and ( inDateTimeString[16] = ':' ) then begin
                	hour := StrToIntDef( Copy(inDateTimeString, 12, 1), 0 );
                    min  := StrToIntDef( Copy(inDateTimeString, 14, 2), 0 );
                    sec  := StrToIntDef( Copy(inDateTimeString, 17, 2), 0 );
                end else if( inDateTimeString[14] = ':' ) and ( inDateTimeString[17] = ':' ) then begin
                	hour := StrToIntDef( Copy(inDateTimeString, 12, 2), 0 );
                    min  := StrToIntDef( Copy(inDateTimeString, 15, 2), 0 );
                    sec  := StrToIntDef( Copy(inDateTimeString, 18, 2), 0 );
                end;
            end;
            try
            	Result := EncodeDateTime(y ,m, d, hour, min, sec, 0);
            except
                Result := ZERO_DATE;
            end;
        end else
        	Result := ZERO_DATE;
    end;


   // Result := inDateTimeString;
end;
// TuWFNgURL擾
function TBoard.GetReadCgiURL: string;
begin
	//Result := URL + SUBJECT_FILENAME;
	//Result := GikoSys.UrlToServer(URL)
	//				+ 'test/read.cgi/' + BBSID + '/?raw=0.0';
	Result := URL + SUBJECT_FILENAME;

end;

// TuWFNgt@C擾ipX{t@Cj
function TBoard.GetSubjectFileName: string;
begin
	if Length( FilePath ) > 0 then
		Result := FilePath
	else
		Result := GikoSys.Setting.LogFolderP
						+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + SUBJECT_FILENAME;
end;

// CfbNXt@C(folder.idx)擾ipX{t@Cj
function TBoard.GetFolderIndexFileName: string;
begin
	if Length( FilePath ) > 0 then
		Result := ExtractFilePath( FilePath ) + FOLDER_INDEX_FILENAME
	else
		Result := GikoSys.Setting.LogFolderP
						+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + FOLDER_INDEX_FILENAME;
end;
//SETTING.TXT̃t@C擾
function TBoard.GetSETTINGTXTFileName: string;
begin
	if Length( FilePath ) > 0 then
		Result := ExtractFilePath( FilePath ) + SETTINGTXT_FILENAME
	else
		Result := GikoSys.Setting.LogFolderP
						+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + SETTINGTXT_FILENAME;
end;

function TBoard.GETHEADTXTFileName: string;
begin
	if Length( FilePath ) > 0 then
		Result := ExtractFilePath( FilePath ) + HEADTXT_FILENAME
	else
		Result := GikoSys.Setting.LogFolderP
						+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + HEADTXT_FILENAME;
end;
function TBoard.GetTitlePictureFileName: string;
var
	tmpName: string;
begin
	if FTitlePictureURL = '' then
		Result := ''
	else begin
		tmpName := Copy(FTitlePictureURL, LastDelimiter('/', FTitlePictureURL) + 1, Length(FTitlePictureURL));
		if Length( FilePath ) > 0 then
			Result := ExtractFilePath( FilePath ) + tmpName
		else
			Result := GikoSys.Setting.LogFolderP
							+ BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + tmpName;
	end;
end;

// XđMURL
function TBoard.GetSendURL: string;
var
	Protocol, Host, Path, Document, Port, Bookmark : string;
begin
    Result := GikoSys.UrlToServer(URL);
    GikoSys.ParseURI( URL, Protocol,Host, Path, Document, Port, Bookmark );
    if GikoSys.Is2chHost(Host) then
        Result := Result + 'test/bbs.cgi'
    else
        Result := Result + 'test/subbbs.cgi';

end;

procedure TBoard.SetRound(b: Boolean);
begin
	if b then
		RoundList.Add(Self)
	else
		RoundList.Delete(Self);
	if FRound = b then Exit;
	FRound := b;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetRoundName(s: string);
begin
	if FRoundName = s then Exit;
	FRoundName := s;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetLastModified(d: TDateTime);
begin
	if FLastModified = d then Exit;
	FLastModified := d;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetLastGetTime(d: TDateTime);
begin
	if FLastGetTime = d then Exit;
	FLastGetTime := d;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetUnRead(i: Integer);
begin
	if FUnRead = i then Exit;
	if i < 0 then i := 0;
	FUnRead := i;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetKotehanName(s: string);
begin
	if FKotehanName = s then Exit;
	FKotehanName := s;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetKotehanMail(s: string);
begin
	if FKotehanMail = s then Exit;
	FKotehanMail := s;
	if FUpdate then
		FModified := True;
end;

function TBoard.GetNewThreadCount: Integer;
var
	i: Integer;
begin
	Result := 0;
	if Length( ParentCategory.ParenTBBS.ShortSelectText ) = 0 then
	begin
		for i := 0 to Count - 1 do begin
			if Items[i].NewArrival then
				inc(Result);
		end;
	end else begin
		for i := 0 to Count - 1 do begin
			if Items[i].NewArrival then
			begin
				if Items[i].ShortTitle = '' then
					Items[i].ShortTitle := CustomStringReplace(ZenToHan(Items[i].Title), ' ', '');
				if AnsiPos(ParentCategory.ParenTBBS.ShortSelectText, Items[i].ShortTitle) <> 0 then
					inc(Result);
			end;
		end;
	end;
end;

function TBoard.GetLogThreadCount: Integer;
var
	i: Integer;
begin
	Result := 0;
	if Length( ParentCategory.ParenTBBS.ShortSelectText ) = 0 then
	begin
		for i := 0 to Count - 1 do begin
			if Items[i].IsLogFile then
				inc(Result);
		end;
	end else begin
		for i := 0 to Count - 1 do begin
			if Items[i].IsLogFile then
			begin
				if Items[i].ShortTitle = '' then
					Items[i].ShortTitle := CustomStringReplace(ZenToHan(Items[i].Title), ' ', '');
				if AnsiPos(ParentCategory.ParenTBBS.ShortSelectText, Items[i].ShortTitle) <> 0 then
					inc(Result);
			end;
		end;
	end;
end;

function TBoard.GetUserThreadCount: Integer;
var
	i: Integer;
begin
	Result := 0;
	if Length( ParentCategory.ParenTBBS.ShortSelectText ) = 0 then
		Result := Count
	else
		for i := 0 to Count - 1 do begin
			if Items[i].ShortTitle = '' then
				Items[i].ShortTitle := CustomStringReplace(ZenToHan(Items[i].Title), ' ', '');
			if AnsiPos(ParentCategory.ParenTBBS.ShortSelectText, Items[i].ShortTitle) <> 0 then
				inc(Result);
		end;
end;

function TBoard.GetNewThread(Index: Integer): TThreadItem;
var
	i: Integer;
	Cnt: Integer;
begin
	Result := nil;
	Cnt := 0;
	if Length( ParentCategory.ParenTBBS.ShortSelectText ) = 0 then
	begin
		for i := 0 to Count - 1 do begin
			if Items[i].NewArrival then
									begin
				if Index = Cnt then begin
					Result := Items[i];
					Exit;
				end;
				inc(Cnt);
			end;
		end;
	end else begin
		for i := 0 to Count - 1 do begin
			if Items[i].NewArrival then
			begin
				if Items[i].ShortTitle = '' then
					Items[i].ShortTitle := CustomStringReplace(ZenToHan(Items[i].Title), ' ', '');
				if AnsiPos(ParentCategory.ParenTBBS.ShortSelectText, Items[i].ShortTitle) <> 0 then begin
					if Index = Cnt then begin
						Result := Items[i];
						Exit;
					end;
					inc(Cnt);
				end;
			end;
		end;
	end;
end;

function TBoard.GetLogThread(Index: Integer): TThreadItem;
var
	i: Integer;
	Cnt: Integer;
begin
	Cnt := 0;
	if Length( ParentCategory.ParenTBBS.ShortSelectText ) = 0 then
	begin
		for i := 0 to Count - 1 do begin
			if Items[i].IsLogFile then
									begin
				if Index = Cnt then begin
					Result := Items[i];
					Exit;
				end;
				inc(Cnt);
			end;
		end;
	end else begin
		for i := 0 to Count - 1 do begin
			if Items[i].IsLogFile then
				begin
					if Items[i].ShortTitle = '' then
						Items[i].ShortTitle := ZenToHan(Items[i].Title);
					if AnsiPos(ParentCategory.ParenTBBS.ShortSelectText, Items[i].ShortTitle) <> 0 then begin
						if Index = Cnt then begin
							Result := Items[i];
							Exit;
					end;
					inc(Cnt);
				end;
			end;
		end;
	end;
	Result := nil;
end;

function TBoard.GetUserThread(Index: Integer): TThreadItem;
var
	i: Integer;
	Cnt: Integer;
begin
	Result := nil;
	Cnt := 0;
	if Length( ParentCategory.ParenTBBS.ShortSelectText ) = 0 then
	begin
		for i := 0 to Count - 1 do begin
			if Index = Cnt then
			begin
				Result := Items[ i ];
				Exit;
			end;
			inc( Cnt );
		end;
	end else begin
		for i := 0 to Count - 1 do begin
			if Items[i].ShortTitle = '' then
				Items[i].ShortTitle := CustomStringReplace(ZenToHan(Items[i].Title), ' ', '');
			if AnsiPos(ParentCategory.ParenTBBS.ShortSelectText, Items[i].ShortTitle) <> 0 then begin
				if Index = Cnt then begin
					Result := Items[i];
					Exit;
				end;
				inc(Cnt);
			end;
		end;
	end;
end;

procedure TBoard.BeginUpdate;
begin
	FUpdate := False;
end;

procedure TBoard.EndUpdate;
begin
	FUpdate := True;
end;

{class function TBoard.GetColumnName(Index: Integer): string;
begin
	Result := COLUMN_THREADITEM[Index];
end;

class function TBoard.GetColumnCount: Integer;
begin
	Result := Length(COLUMN_THREADITEM);
end;}

//constructor TThreadItem.Create(AOwner: TComponent);
procedure TThreadItem.Init;
begin
	FNo := 0;
	FFileName := '';
	FTitle := '';
	FRoundDate := ZERO_DATE;
	FLastModified := ZERO_DATE;
	FCount := 0;
	FAllResCount := 0;
	FNewResCount := 0;
	FSize := 0;
	FRound := False;
	FIsLogFile := False;
	FParentBoard := nil;
	FKokomade := -1;
	FNewReceive := 0;
	FNewArrival := False;

	FUpdate := True;
	FURL := '';
	FBoardPlugIn := nil;
end;

// *************************************************************************
// OvOCw肵RXgN^
// *************************************************************************
constructor TThreadItem.Create(
	inPlugIn	: TBoardPlugIn;
	inURL			: string
);
var
	foundPos			: Integer;
	protocol, host, path, document, port, bookmark	: string;
	BBSID, BBSKey	: string;
const
	READ_PATH							= '/test/read.cgi';
begin

	inherited Create;
	Init;

	FBoardPlugIn	:= inPlugIn;
	URL						:= inURL;

	if inPlugIn = nil then begin
		foundPos := Pos( READ_PATH, inURL );
		if foundPos > 0 then begin
			// dat ̕ۑpXݒ
			GikoSys.ParseURI( inURL, protocol, host, path, document, port, bookmark );
			GikoSys.Parse2chURL( inURL, path, document, BBSID, BBSKey );
			if GikoSys.Is2chHost( host ) then
				FilePath :=
					GikoSys.Setting.LogFolderP +
					BBS2CH_LOG_FOLDER + PATH_DELIM + BBSID + PATH_DELIM + BBSKey + '.dat'
			else
				FilePath :=
					GikoSys.Setting.LogFolderP +
					EXTERNAL_LOG_FOLDER + PATH_DELIM + host + PATH_DELIM + BBSID + PATH_DELIM + BBSKey + '.dat';
			FileName	:= BBSKey + '.dat';
			IsLogFile	:= FileExists( FilePath );
			URL				:= GikoSys.Get2chBrowsableThreadURL( inURL );
		end;
	end else begin
		// vOC TThreadItem 쐬ꂽƂ`
		inPlugIn.CreateThreadItem( DWORD( Self ) );
	end;

end;

// *************************************************************************
// vOC𗘗pȂRXgN^
// *************************************************************************
constructor TThreadItem.Create(
	is2ch : Boolean;
    const inURL, inHost, inBBSID, inBBSKey : string
);
var
	foundPos			: Integer;
const
	READ_PATH							= '/test/read.cgi';
begin

	inherited Create;
	Init;

	FBoardPlugIn	:= nil;

    foundPos := Pos( READ_PATH, inURL );
    if foundPos > 0 then begin
        // dat ̕ۑpXݒ
        if is2ch then
            FilePath :=

                GikoSys.Setting.LogFolderP +
                BBS2CH_LOG_FOLDER + PATH_DELIM + inBBSID + PATH_DELIM + inBBSKey + '.dat'
        else
            FilePath :=
                GikoSys.Setting.LogFolderP +
                EXTERNAL_LOG_FOLDER + PATH_DELIM + inHost + PATH_DELIM + inBBSID + PATH_DELIM + inBBSKey + '.dat';
        FileName	:= inBBSKey + '.dat';
        IsLogFile	:= FileExists( FilePath );
        URL				:= GikoSys.Get2chBrowsableThreadURL( inURL );
    end else
    	URL				:= inURL;

end;
// *************************************************************************
// fXgN^
// *************************************************************************
destructor TThreadItem.Destroy;
begin

	// vOC TThreadItem jꂽƂ`
	if IsBoardPlugInAvailable then
		FBoardPlugIn.DisposeThreadItem( DWORD( Self ) );

	inherited;

end;

// *************************************************************************
// OvOCgp\
// *************************************************************************
function	TThreadItem.IsBoardPlugInAvailable : Boolean;
begin

	repeat
		if BoardPlugIn = nil then
			Break;

		if not Assigned( Pointer( BoardPlugIn.Module ) ) then
			Break;

		Result := True;
		Exit;
	until True;

	Result := False;

end;

function TThreadItem.GetDatURL: string;
var
	Protocol, Host, Path, Document, Port, Bookmark: string;
begin
	Result := ParentBoard.URL
					+ 'dat/'
					+ FileName;
	if FDownloadHost <> '' then begin
		GikoSys.ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		Result := Format('%s://%s%s%s', [Protocol,
																		 FDownloadHost,
																		 Path,
																		 Document]);
	end;
//	Result := GikoSys.UrlToServer(ParentBoard.URL)
//					+ 'test/read.cgi/' + ParentBoard.BBSID + '/'
//					+ ChangeFileExt(FileName, '') + '/?raw='
//					+ IntToStr(ResNum) + '.' + IntToStr(ResSize);
end;

function TThreadItem.GetDatgzURL: string;
	function isOldKako(s: string): Boolean;
	begin
		Result := False;
		if AnsiPos('piza.', s) <> 0 then
			Result := True
		else if AnsiPos('www.bbspink.', s) <> 0 then
			Result := True
		else if AnsiPos('tako.', s) <> 0 then
			Result := True;
	end;
var
	Protocol, Host, Path, Document, Port, Bookmark: string;
	DatNo: string;
begin
	if FDownloadHost = '' then begin
		DatNo := ChangeFileExt(FileName, '');
		if isOldKako(ParentBoard.URL) then begin
			Result := Format('%s%s/%.3s/%s.dat', [ParentBoard.URL, 'kako', DatNo, DatNo]);
		end else begin
			if Length(DatNo) > 9 then begin
				//http://xxx.2ch.net/xxx/kako/9999/99999/999999999.dat.gz
				Result := Format('%s%s/%.4s/%.5s/%s.dat.gz', [ParentBoard.URL, 'kako', DatNo, DatNo, DatNo]);
			end else begin
				//http://xxx.2ch.net/xxx/kako/999/999999999.dat.gz
				Result := Format('%s%s/%.3s/%s.dat.gz', [ParentBoard.URL, 'kako', DatNo, DatNo]);
			end;
		end;
	end else begin
		Gikosys.ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		DatNo := ChangeFileExt(Document, '');
		if isOldKako(DownloadHost) then begin
			Result := Format('%s://%s/%s/kako/%.3s/%s.dat', [Protocol, DownloadHost, ParentBoard.FBBSID, DatNo, DatNo]);
		end else begin
			if Length(DatNo) > 9 then begin
				Result := Format('%s://%s/%s/kako/%.4s/%.5s/%s.dat.gz', [Protocol, DownloadHost, ParentBoard.FBBSID, DatNo, DatNo, DatNo]);
			end else begin
				Result := Format('%s://%s/%s/kako/%.3s/%s.dat.gz', [Protocol, DownloadHost, ParentBoard.FBBSID, DatNo, DatNo]);
			end;
		end;
	end;
end;

{function TThreadItem.GetOldDatgzURL: string;
var
	Protocol, Host, Path, Document, Port, Bookmark: string;
begin
	Result := Format('%s%s/%.3s/%s.gz', [ParentBoard.URL,
																			 'kako',
																			 FileName,
																			 FileName]);
	if FDownloadHost <> '' then begin
		ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		Result := Format('%s://%s%s%s', [Protocol,
																		 DownloadHost,
																		 Path,
																		 Document]);

	end;
end;}

function TThreadItem.GetOfflawCgiURL(const SessionID: string): string;
//var
//	Protocol, Host, Path, Document, Port, Bookmark: string;
begin
//	Result := GikoSys.UrlToServer(ParentBoard.URL)
//					+ 'test/offlaw.cgi/' + ParentBoard.BBSID + '/'
//					+ ChangeFileExt(FileName, '') + '/?raw=.0&sid=' + HttpEncode(SessionID);
	if FDownloadHost = '' then begin
		Result := GikoSys.UrlToServer(ParentBoard.URL)
						+ 'test/offlaw.cgi/' + ParentBoard.BBSID + '/'
						+ ChangeFileExt(FileName, '') + '/?raw=.0&sid=' + HttpEncode(SessionID);
	end else begin
		//http://news.2ch.net/test/offlaw.cgi/newsplus/1014038577/?raw=.196928&sid=
		//GikoSys.ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		Result := 'http://' + FDownloadHost
						+ '/test/offlaw.cgi/' + ParentBoard.BBSID + '/'
						+ ChangeFileExt(FileName, '') + '/?raw=.0&sid=' + HttpEncode(SessionID);
//		Result := Format('%s://%s%s%s', [Protocol,
//																		 DownloadHost,
//																		 Path,
//																		 Document]);
	end;
end;

function TThreadItem.GetSendURL: string;
begin
	Result := GikoSys.UrlToServer(ParentBoard.URL)
					+ 'test/bbs.cgi';
end;

procedure TThreadItem.DeleteLogFile;
begin
	ParentBoard.BeginUpdate;

	if FUnRead then
		ParentBoard.UnRead := ParentBoard.UnRead - 1;
	DeleteFile(GetThreadFileName);
	if FileExists(ChangeFileExt(GetThreadFileName,'.NG')) = true then
		DeleteFile(ChangeFileExt(GetThreadFileName,'.NG'));
	FRoundDate := ZERO_DATE;
	FLastModified := ZERO_DATE;
	FSize := 0;
	FIsLogFile := False;
	FKokomade := -1;
	FNewReceive := 0;
	FNewArrival := False;
	FUnRead := False;
	FScrollTop := 0;
	FRound := False;
	FDownloadHost := '';
	FAgeSage := gasNone;

	FCount := 0;
	FNewResCount := 0;
	FRoundName := '';

	ParentBoard.EndUpdate;
	ParentBoard.Modified := True;
end;

function TThreadItem.GetThreadFileName: string;
begin
	if Length( FilePath ) > 0 then
		Result := FilePath
	else
		Result := GikoSys.Setting.LogFolderP
						+ BBS2CH_LOG_FOLDER + PATH_DELIM + ParentBoard.BBSID + PATH_DELIM + FileName;
end;

procedure TThreadItem.SetLastModified(d: TDateTime);
begin
	if FLastModified = d then Exit;
	FLastModified := d;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

{procedure TThreadItem.SetRoundNo(i: Integer);
begin
	if FRoundNo = i then Exit;
	FRoundNo := i;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;}

procedure TThreadItem.SetRound(b: Boolean);
begin
	if b then
		RoundList.Add(Self)
	else
		RoundList.Delete(Self);
	if FRound = b then Exit;
	FRound := b;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetRoundName(const s: string);
begin
	if FRoundName = s then Exit;
	FRoundName := s;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetKokomade(i: Integer);
begin
	if FKokomade = i then Exit;
	FKokomade := i;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetUnRead(b: Boolean);
begin
	if FUnRead = b then Exit;
	FUnRead := b;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetScrollTop(i: Integer);
begin
	if FScrollTop = i then Exit;
	FScrollTop := i;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.BeginUpdate;
begin
	FUpdate := False;
end;

procedure TThreadItem.EndUpdate;
begin
	FUpdate := True;
end;

{initialization
	BBS2ch := TBBS.Create;

finalization
	if BBS2ch <> nil then
		BBS2ch.Free;}
function TThreadItem.GetCreateDate: TDateTime;
var
	unixtime: Int64;
    tmp: string;
begin
	// t@CX쐬߂
	try
		if ( GikoSys.Setting.CreationTimeLogs ) and not IsLogFile  then
            Result := ZERO_DATE
        else begin
            // Ot@C̊gq͂̂X쐬
			tmp := ChangeFileExt(FFileName, '');
			if AnsiPos('_', tmp) <> 0 then
				if AnsiPos('_', tmp) > 9 then
					tmp := Copy(tmp, 1, AnsiPos('_', tmp)-1)
				else
					Delete(tmp, AnsiPos('_', tmp), 1);

			if ( Length(tmp) = 9) and ( tmp[1] = '0' ) then
				Insert('1', tmp, 1);

			unixtime := StrToInt64Def(tmp, ZERO_DATE);
			Result := UnixToDateTime(unixtime) + OffsetFromUTC;
			if GikoSys.Setting.FutureThread then begin
        		if CompareDateTime(Result, Now) = 1 then
            		Result := ZERO_DATE;
        	end;
        end;

	except
		on E: Exception do
			Result := ZERO_DATE;
	end;
end;

end.

