unit ToolBarUtil;

interface

uses
	Windows, Messages, SysUtils, Classes, Controls,
	StdCtrls, ExtCtrls, ComCtrls, ActnList, IniFiles,
	GikoSystem;

const
	//Wc[o[ftHg
	DEF_STANDARD: array[0..6]  of string = ('RoundAction',
																					'',
																					'CabinetVisibleAction',
																					'ArrangeAction',
																					'',
																					'StopAction',
																					'LoginAction');
	//Xgc[o[ftHg
	DEF_LIST:    	array[0..16] of string = ('ListNumberVisibleAction',
																					'IconStyle',
																					'UpFolderAction',
																					'',
																					'AllItemAction',
																					'LogItemAction',
																					'NewItemAction',
																					'SelectItemAction',
																					'',
																					'ThreadEditorAction',
																					'',
																					'BoardIEAction',
																					'',
																					'SelectListReloadAction',
																					'SelectThreadReloadAction',
																					'',
																					'SelectReservAction');
	//uEUc[o[ftHg
	DEF_BROWSER:  array[0..15] of string = ('BrowserMaxAction',
																					'BrowserMinAction',
																					'',
																					'ScrollTopAction',
																					'ScrollLastAction',
																					'ScrollNewAction',
																					'ScrollKokoAction',
																					'',
																					'AllResAction',
																					'SelectResAction',
																					'',
																					'EditorAction',
																					'',
																					'IEAction',
																					'',
																					'ItemReloadAction');


	//{^X^C"tbsCheck"{^̃ANV
	CHECK_STYLE:   array[0..30] of string = ('CabinetVisibleAction',
																					'ArrangeAction',
																					'AllItemAction',
																					'LogItemAction',
																					'NewItemAction',
																					'SelectItemAction',

																					'StdToolBarVisibleAction',
																					'AddressBarVisibleAction',
																					'LinkBarVisibleAction',
																					'ListToolBarVisibleAction',
																					'ListNameBarVisibleAction',
																					'BrowserToolBarVisibleAction',
																					'BrowserNameBarVisibleAction',
																					'MsgBarVisibleAction',
																					'StatusBarVisibleAction',
																					'Cabinet2chAction',
																					'CabinetHistoryAction',
																					'LargeIconAction',
																					'SmallIconAction',
																					'ListIconAction',
																					'DetailIconAction',
																					'BrowserTabVisibleAction',
																					'BrowserTabTopAction',
																					'BrowserTabBottomAction',
																					'BrowserTabTabStyleAction',
																					'BrowserTabButtonStyleAction',
																					'BrowserTabFlatStyleAction',
																					'LoginAction',
																					'ListNumberVisibleAction',
																					'AllResAction',
																					'SelectResAction'
																					);

	//{^̃X^C"tbsDropDown"{^̃ANV
	DROPDOWN_STYLE: array[0..1] of string = ('IconStyle',
																					 'IEAction');

	INI_FILENAME: string = 'ToolBar.ini';

	function IsCheckStyle(Action: TCustomAction): Boolean;
	function IsDropDownStyle(Action: TCustomAction): Boolean;
	procedure SetButtonStyle(Action: TCustomAction; Button: TToolButton);
	function GetActionItem(ActionList: TActionList; ActionName: string): TCustomAction;
	procedure ReadToolBarSetting(ActionList: TActionList; ToolBar: TToolBar);
	procedure SaveToolBarSetting(ToolBar: TToolBar);

implementation

procedure ReadToolBarSetting(ActionList: TActionList; ToolBar: TToolBar);
var
	FileName: string;
	ini: TMemIniFile;
	i: Integer;
	s: string;
	Action: TCustomAction;
	ToolButton: TToolButton;
begin
	FileName := GikoSys.GetConfigDir + INI_FILENAME;
	if FileExists(FileName) then begin
		for i := ToolBar.ButtonCount - 1 downto 0 do
			ToolBar.RemoveControl(ToolBar.Buttons[i]);

		ini := TMemIniFile.Create(FileName);
		try
			i := 0;
			while True do begin
				s := ini.ReadString(ToolBar.Name, 'Button' + IntToStr(i), '');
				if s = '-' then begin
					ToolButton := TToolButton.Create(ToolBar);
					ToolButton.Style := tbsSeparator;
					ToolButton.Width := 8;
					ToolButton.Left := 10000;
					ToolBar.InsertControl(ToolButton);
				end else if s <> '' then begin
					Action := GetActionItem(ActionList, s);
					if Action <> nil then begin
						ToolButton := TToolButton.Create(ToolBar);
						ToolButton.Action := Action;
						ToolButton.Left := 10000;
						SetButtonStyle(Action, ToolButton);
						ToolBar.InsertControl(ToolButton);
					end;
				end else
					Break;
				inc(i);
			end;
		finally
			ini.Free;
		end;
	end;
end;

procedure SaveToolBarSetting(ToolBar: TToolBar);
var
	ini: TMemIniFile;
	i, j: Integer;
	Action: TBasicAction;
begin
	ini := TMemIniFile.Create(GikoSys.GetConfigDir + INI_FILENAME);
        j := 0;
	try
		ini.EraseSection(ToolBar.Name);
		for i := 0 to ToolBar.ButtonCount - 1 do begin
			if ToolBar.Buttons[i].Style = tbsSeparator then begin
                                ini.WriteString(ToolBar.Name, 'Button' + IntToStr(j), '-');
                                Inc( j );
			end else begin
				Action := ToolBar.Buttons[i].Action;
				if Action <> nil then
                                begin
					ini.WriteString(ToolBar.Name, 'Button' + IntToStr(j), Action.Name);
                                        Inc( j );
                                end;
			end;
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//ActionNameActionԂ܂
function GetActionItem(ActionList: TActionList; ActionName: string): TCustomAction;
var
	i: Integer;
begin
	for i := 0 to ActionList.ActionCount - 1 do begin
		if ActionList.Actions[i].Name = ActionName then begin
			Result := TCustomAction(ActionList.Actions[i]);
			Exit;
		end;
	end;
	Result := nil;
end;

//c[{^̃X^Cݒƃ|bvAbvݒ
procedure SetButtonStyle(Action: TCustomAction; Button: TToolButton);
begin
	if IsCheckStyle(Action) then
		Button.Style := tbsCheck
	else if IsDropDownStyle(Action) then
		Button.Style := tbsDropDown
	else
		Button.Style := tbsButton;
end;

//Action`FbNX^C̃ANVǂԂ܂
function IsCheckStyle(Action: TCustomAction): Boolean;
var
	i: Integer;
begin
	for i := 0 to Length(CHECK_STYLE) - 1 do begin
		if Action.Name = CHECK_STYLE[i] then begin
			Result := True;
			Exit;
		end;
	end;
	Result := False;
end;

//Actionhbv_EX^C̃ANVǂԂ܂
function IsDropDownStyle(Action: TCustomAction): Boolean;
var
	i: Integer;
begin
	for i := 0 to Length(DROPDOWN_STYLE) - 1 do begin
		if Action.Name = DROPDOWN_STYLE[i] then begin
			Result := True;
			Exit;
		end;
	end;
	Result := False;
end;

end.
