unit BoardGroup;

interface

uses
	SysUtils, Classes, ComCtrls, IniFiles, {HTTPApp,} YofUtils, IdGlobal;

type
	//Xg̕\ACeI
	TGikoViewType = (gvtAll, gvtLog, gvtNew, gvtUser);
	//Xg̎擾
	//TGikoListCount = (glc50, glc100, glc200, glc500, glc1000, glcAll);
	//ԍ
	//TGikoRoundNo = (grnNone, grn1, grn2, grn3, grn4, grn5, grnOnce);
	//Xg̏グ
	TGikoAgeSage = (gasNone, gasAge, gasSage, gasNew);

{	TFolder = class
	private
		FItemList: TList;	//qACeXg
		FLeaf: Boolean;		//ɃtH_Ƃo邩
	public
		function Add(Item: TFolder): Integer;
		procedure Clear;
		procedure Delete(Index: Integer);
		procedure Exchange(Index1, Index2: Integer);
		procedure Insert(Index: Integer; Item: TFolder);
		procedure Move(CurIndex, NewIndex: Integer);
		function Remove(Item: TFolder): Integer;
		procedure Sort(Compare: TListSortCompare);
		property Capacity: Integer read FCapacity write SetCapacity;
		property Count: Integer read FCount write SetCount;
		property Items[Index: Integer]: TFolder read Get write Put; default;

		property Leaf: Boolean read FLeaf;
	end;

	TBBS = class(TFolder)
	end;
	TCategory class(TFolder)
	end;
	TBoard = class(TFolder)
	end;
	TThreadItem = class(TFolder)
	end;
}

{
	TBBS2ch = class(TBBS)
	end;
	TBoard2ch = class(TBoard)
	end;
	TThreadItem2ch = class(TThreadItem)
	end;
}

//	ITest = interface
//	end;
//	IBBS = interface
//	end;
//	ICategory = interface
//	end;
//	IBoard = interface
//	end;
//	IThreadItem = interface
//	end;

	TCategory = class;
	TBoard = class;
	TThreadItem = class;

	//Ƃ肠Q˂̃[g
	TBBS2ch = class(TList)
	private
		FTitle: string;
		FLogFolder: string;
		FExpand: Boolean;
		FKubetsuChk: Boolean;					//iݎ啶
		FSelectText: string;					//iݕ
		FShortSelectText: string;

		function GetCategory(index: integer): TCategory;
		procedure SetCategory(index: integer; value: TCategory);
		procedure SetSelectText(s: string);
	public
		constructor Create(LogFolder: string);
		destructor Destroy; override;

		procedure ReadBoardFile;

		function GetBoardFromBBSID(BBSID: string): TBoard;

		function Add(item: TCategory): integer;
		procedure Delete(index: integer);
		procedure Clear; override;
		function Find(key: string): TCategory;
		function FindBBSID(BBSID: string): TBoard;
		function FindBoardFromTitle(Title: string): TBoard;
		function FindThreadItem(BBSID: string; FileName: string): TThreadItem;
		function GetLogFolder: string;

		property Items[index: integer]: TCategory read GetCategory write SetCategory;
		property Title: string read FTitle write FTitle;
		property NodeExpand: Boolean read FExpand write FExpand;

		property KubetsuChk: Boolean read FKubetsuChk write FKubetsuChk;
		property SelectText: string read FSelectText write SetSelectText;
		property ShortSelectText: string read FShortSelectText write FShortSelectText;
	end;

	//JeS
	TCategory = class(TList)
	private
		FNo: Integer;
		FTitle: string;
		FParentBBS2ch: TBBS2ch;
		FExpand: Boolean;

		function GetBoard(index: integer): TBoard;
		procedure SetBoard(index: integer; value: TBoard);
	public
		constructor Create;
		destructor Destroy; override;

		property No: Integer read FNo write FNo;
		property Title: string read FTitle write FTitle;
		property Items[index: integer]: TBoard read GetBoard write SetBoard;
		property ParentBBS2ch: TBBS2ch read FParentBBS2ch write FParentBBS2ch;

		function Add(item: TBoard): integer;
		procedure Delete(index: integer);
		procedure Clear; override;
		function FindName(key: string): TBoard;
		function FindBBSID(BBSID: string): TBoard;
		function FindBoardFromTitle(Title: string): TBoard;
		function IsMidoku: Boolean;

		property NodeExpand: Boolean read FExpand write FExpand;
	end;

	//
	TBoard = class(TList)
	private
		FNo: Integer;									//ԍ
		FTitle: string;								//{[h^Cg
		FBBSID: string;								//BBSID
		FURL: string;									//{[hURL
		FRound: Boolean;							//Xbhꗗ\
		FRoundName: string;						//
		FRoundDate: TDateTime;				//Xbhꗗ擾ij
		FLastModified: TDateTime;			//XbhꗗXVĂiT[oj
		FLastGetTime: TDateTime;			//Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
		FIsThreadDatRead: Boolean;		//XbhXg͓ǂݍ܂Ă邩H
		FUnRead: Integer;							//Xbhǐ
		FParentCategory: TCategory;   //eJeS
		FModified: Boolean;						//CtO
		FBoolData: Boolean;						//ȗprɎgyo
		FSPID: string;								//ݗpSPID
		FPON: string;									//ݗpPON
		FKotehanName: string;					//RenO
		FKotehanMail: string;					//Ren[

		FUpdate: Boolean;
		FExpand: Boolean;

		function GetThreadItem(index: integer): TThreadItem;
		procedure SetThreadItem(index: integer; value: TThreadItem);
		procedure SetRound(b: Boolean);
		procedure SetRoundName(s: string);
		procedure SetLastModified(d: TDateTime);
		procedure SetLastGetTime(d: TDateTime);
		procedure SetUnRead(i: Integer);
		procedure SetKotehanName(s: string);
		procedure SetKotehanMail(s: string);
	public
		constructor Create;
		destructor Destroy; override;

		property Items[index: integer]: TThreadItem read GetThreadItem write SetThreadItem;
		property No: Integer read FNo write FNo;
		property Title: string read FTitle write FTitle;
		property BBSID: string read FBBSID write FBBSID;
		property URL: string read FURL write FURL;
		property Round: Boolean read FRound write SetRound;
		property RoundName: string read FRoundName write SetRoundName;
		property RoundDate: TDateTime read FRoundDate write FRoundDate;
		property LastModified: TDateTime read FLastModified write SetLastModified;
		property LastGetTime: TDateTime read FLastGetTime write SetLastGetTime;
		property UnRead: Integer read FUnRead write SetUnRead;
		property Modified: Boolean read FModified write FModified;
		property IsThreadDatRead: Boolean read FIsThreadDatRead write FIsThreadDatRead;
		property ParentCategory: TCategory read FParentCategory write FParentCategory;

		function Add(item: TThreadItem): integer;
		procedure Insert(Index: Integer; Item: TThreadItem);
		procedure Delete(index: integer);
		procedure DeleteList(index: integer);
		procedure Clear; override;
		function Find(ItemFileName: string): TThreadItem;
		function GetIndex(ItemFileName: string): Integer;
		procedure LoadSettings;
		procedure SaveSettings;
		function GetReadCgiURL: string;
		function GetSubjectFileName: string;
		function GetFolderIndexFileName: string;
		function GetSendURL: string;

		function GetNewThreadCount: Integer;
		function GetLogThreadCount: Integer;
		function GetUserThreadCount: Integer;
		function GetNewThread(Index: Integer): TThreadItem;
		function GetLogThread(Index: Integer): TThreadItem;
		function GetUserThread(Index: Integer): TThreadItem;

		procedure BeginUpdate;
		procedure EndUpdate;
		property NodeExpand: Boolean read FExpand write FExpand;
		property BoolData: Boolean read FBoolData write FBoolData;
		property SPID: string read FSPID write FSPID;
		property PON: string read FPON write FPON;
		property KotehanName: string read FKotehanName write SetKotehanName;
		property KotehanMail: string read FKotehanMail write SetKotehanMail;
	end;

	//X
	TThreadItem = class(TObject)
	private
		FNo: Integer;							//ԍ
		FFileName: string;				//Xbht@C
		FTitle: string;						//Xbh^Cg
		FShortTitle: string;			//ZXbh^Cgipj
		FRoundDate: TDateTime;		//Xbh擾ij
		FLastModified: TDateTime; //XbhXVĂiT[oj
		FCount: Integer;					//XbhJEgi[Jj
		FAllResCount: Integer;		//XbhJEgiT[oj
		FNewResCount: Integer;		//XbhV
		FSize: Integer;						//XbhTCY
		FRound: Boolean;					//tO
		FRoundName: string;				//
		FIsLogFile: Boolean;			//O݃tO
		FParentBoard: TBoard;			//e{[h
		FKokomade: Integer;				//RR܂œǂ񂾔ԍ
		FNewReceive: Integer; 		//RRVKM
		FNewArrival: Boolean;			//V
		FUnRead: Boolean;					//ǃtO
		FScrollTop: Integer;			//XN[ʒu
		FDownloadHost: string;		//̃zXgƈႤꍇ̃zXg
		FAgeSage: TGikoAgeSage;		//ACȅグ
//		FSPID: string;						//ݗpSPID

		FUpdate: Boolean;
		FExpand: Boolean;

		procedure SetLastModified(d: TDateTime);
		procedure SetRound(b: Boolean);
		procedure SetRoundName(s: string);
		procedure SetKokomade(i: Integer);
		procedure SetUnRead(b: Boolean);
		procedure SetScrollTop(i: Integer);
	public
		constructor Create;
		destructor Destroy; override;

		function GetDatURL: string;
		function GetDatgzURL: string;
//		function GetOldDatgzURL: string;
		function GetOfflawCgiURL(SessionID: string): string;
		function GetSendURL: string;
		procedure DeleteLogFile;
		function GetThreadFileName: string;
		procedure BeginUpdate;
		procedure EndUpdate;

		property No: Integer read FNo write FNo;
		property FileName: string read FFileName write FFileName;
		property Title: string read FTitle write FTitle;
		property ShortTitle: string read FShortTitle write FShortTitle;
		property RoundDate: TDateTime read FRoundDate write FRoundDate;
		property LastModified: TDateTime read FLastModified write SetLastModified;
		property Count: Integer read FCount write FCount;
		property AllResCount: Integer read FAllResCount write FAllResCount;
		property NewResCount: Integer read FNewResCount write FNewResCount;
		property Size: Integer read FSize write FSize;
		property Round: Boolean read FRound write SetRound;
		property RoundName: string read FRoundName write SetRoundName;

		property IsLogFile: Boolean read FIsLogFile write FIsLogFile;
		property ParentBoard: TBoard read FParentBoard write FParentBoard;
		property Kokomade: Integer read FKokomade write SetKokomade;
		property NewReceive: Integer read FNewReceive write FNewReceive;
		property NewArrival: Boolean read FNewArrival write FNewArrival;
		property UnRead: Boolean read FUnRead write SetUnRead;
		property ScrollTop: Integer read FScrollTop write SetScrollTop;
		property Expand: Boolean read FExpand write FExpand;
		property DownloadHost: string read FDownloadHost write FDownloadHost;
		property AgeSage: TGikoAgeSage read FAgeSage write FAgeSage;
//		property SPID: string read FSPID write FSPID;
	end;



	//ʃXg
{	TSearchList = class(TList)
	private
		function GetThreadItem(index: integer): TThreadItem;
		procedure SetThreadItem(index: integer; value: TThreadItem);
	public
		constructor Create;
		destructor Destroy; override;

		property Items[index: integer]: TThreadItem read GetThreadItem write SetThreadItem;

		function Add(item: TThreadItem): integer;
		procedure Delete(index: integer);
		procedure Clear; override;
	end;}

var
	BBS2ch: TBBS2ch;

implementation

uses
	GikoSystem, RoundData;

const
	BBS2CH_NAME:           string  = 'Q˂';
	BBS2CH_LOG_FOLDER:     string  = '2ch';

	FOLDER_INI_FILENAME:   string  = 'Folder.ini';
	FOLDER_INDEX_FILENAME: string  = 'Folder.idx';
	SUBJECT_FILENAME:      string  = 'subject.txt';
	PATH_DELIM:            string  = '\';
	//DEFAULT_LIST_COUNT:    Integer = 100;

//	COLUMN_CATEGORY:   array[0..0] of string = ('JeS');
//	COLUMN_BOARD:      array[0..3] of string = ('', '擾', '\', 'O񏄉');
//	COLUMN_THREADITEM: array[0..3] of string = ('Xbh', 'JEg', '\', 'O񏄉');

(*************************************************************************
 *@\FTBBSRXgN^
 *Public
 *************************************************************************)
constructor TBBS2ch.Create(LogFolder: string);
begin
	Title := BBS2CH_NAME;
	FLogFolder := LogFolder;
end;

(*************************************************************************
 *@\FTBBSfXgN^
 *Public
 *************************************************************************)
destructor TBBS2ch.Destroy;
begin
	Clear;
	inherited;
end;

(*************************************************************************
 *@\F
 *Public
 *************************************************************************)
function TBBS2ch.GetCategory(index: integer): TCategory;
begin
	Result := TCategory(inherited Items[index]);
end;

procedure TBBS2ch.SetCategory(index: integer; value: TCategory);
begin
	inherited Items[index] := value;
end;

function TBBS2ch.Add(item: TCategory): integer;
begin
	Item.ParentBBS2ch := self;
	Result := inherited Add(item);
end;

procedure TBBS2ch.Delete(index: integer);
begin
	if Items[index] <> nil then
		TCategory(Items[index]).Free;
	Items[index] := nil;
	inherited Delete(index);
end;

procedure TBBS2ch.Clear;
var
	i: integer;
begin
	for i := Count - 1 downto 0 do
		Delete(i);
end;

function TBBS2ch.Find(key: string): TCategory;
begin
	Result := nil;
end;

function TBBS2ch.FindBBSID(BBSID: string): TBoard;
var
	i: Integer;
	Category: TCategory;
	Board: TBoard;
begin
	Result := nil;
	for i := 0 to Count - 1 do begin
		Category := Items[i];
		Board := Category.FindBBSID(BBSID);
		if Board <> nil then begin
			Result := Board;
			Exit;
		end;
	end;
end;

function TBBS2ch.FindBoardFromTitle(Title: string): TBoard;
var
	i: Integer;
	Category: TCategory;
	Board: TBoard;
begin
	Result := nil;
	for i := 0 to Count - 1 do begin
		Category := Items[i];
		Board := Category.FindBoardFromTitle(Title);
		if Board <> nil then begin
			Result := Board;
			Exit;
		end;
	end;
end;

function TBBS2ch.FindThreadItem(BBSID: string; FileName: string): TThreadItem;
var
	Board: TBoard;
begin
	Result := nil;
	Board := FindBBSID(BBSID);
	if Board = nil then
		Exit;
	Result := Board.Find(FileName);
end;

(*************************************************************************
 *@\@@F{[ht@Cǂݍ
 *@@@FPublic
 *P@@FVK쐬
 *************************************************************************)
procedure TBBS2ch.ReadBoardFile;
var
	i, j: integer;
	idx: Integer;
	ini: TMemIniFile;
	CategoryList: TStringList;
	BoardList: TStringList;
	Category: TCategory;
	Board: TBoard;
	inistr: string;
	RoundItem: TRoundItem;
	BBSList: TStringList;
	CustomList: TStringList;
begin
	ini := TMemIniFile.Create('');
	BBSList := TStringList.Create;
	CustomList := TStringList.Create;
	try
		if FileExists(GikoSys.GetBoardFileName) then
			BBSList.LoadFromFile(GikoSys.GetBoardFileName);
		if FileExists(GikoSys.GetCustomBoardFileName) then
			CustomList.LoadFromFile(GikoSys.GetCustomBoardFileName);
		BBSList.AddStrings(CustomList);
		ini.SetStrings(BBSList);

		CategoryList := TStringList.Create;
		BoardList := TStringList.Create;
		try
			ini.ReadSections(CategoryList);
			for i := 0 to CategoryList.Count - 1 do begin

				ini.ReadSection(CategoryList[i], BoardList);
				Category := TCategory.Create;
				Category.No := i + 1;
				Category.Title := CategoryList[i];

				for j := 0 to BoardList.Count - 1 do begin
					inistr := ini.ReadString(CategoryList[i], BoardList[j], '');
					Board := TBoard.Create;
					Board.BeginUpdate;
					Board.No := j + 1;
					Board.Title := BoardList[j];
					Board.BBSID := GikoSys.UrlToID(inistr);
					Board.URL := inistr;
					Board.RoundDate := ZERO_DATE;

					idx := RoundList.Find(Board);
					if idx <> -1 then begin
						RoundItem := RoundList.Items[idx, grtBoard];
						Board.Round := True;
						Board.RoundName := RoundItem.RoundName;
					end;
					Category.Add(Board);
					Board.EndUpdate;
				end;
				BBS2ch.Add(Category);
			end;
		finally
			BoardList.Free;
			CategoryList.Free;
		end;
	finally
		BBSList.Free;
		CustomList.Free;
		ini.Free;
	end;
end;

function TBBS2ch.GetBoardFromBBSID(BBSID: string): TBoard;
var
	i: integer;
begin
	Result := nil;
	for i := 0 to BBS2ch.Count - 1 do begin
		Result := BBS2ch.Items[i].FindBBSID(BBSID);
		if Result <> nil then
			Exit;
	end;
end;

(*************************************************************************
 *OtH_擾
 *
 *************************************************************************)
function TBBS2ch.GetLogFolder: string;
begin
	Result := IncludeTrailingPathDelimiter(FLogFolder)
					+ BBS2CH_LOG_FOLDER + PATH_DELIM;
end;

procedure TBBS2ch.SetSelectText(s: string);
begin
	FSelectText := s;
	ShortSelectText := GikoSys.ZenToHan(s);
end;

{class function TBBS2ch.GetColumnName(Index: Integer): string;
begin
	Result := COLUMN_CATEGORY[Index];
end;

class function TBBS2ch.GetColumnCount: Integer;
begin
	Result := Length(COLUMN_CATEGORY);
end;}

//===================
//TCategory
//===================
constructor TCategory.Create;
begin
end;

destructor TCategory.Destroy;
begin
	Clear;
	inherited;
end;

function TCategory.GetBoard(index: integer): TBoard;
begin
	Result := TBoard(inherited Items[index]);
end;

procedure TCategory.SetBoard(index: integer; value: TBoard);
begin
	inherited Items[index] := value;
end;

function TCategory.Add(item: TBoard): integer;
begin
	Item.ParentCategory := self;
	Result := inherited Add(item);
end;

procedure TCategory.Delete(index: integer);
begin
	if Items[index] <> nil then
		TBoard(Items[index]).Free;
	Items[index] := nil;
	inherited Delete(index);
end;

procedure TCategory.Clear;
var
	i: integer;
begin
	for i := Count - 1 downto 0 do
		Delete(i);
end;

function TCategory.FindName(key: string): TBoard;
begin
	Result := nil;
end;

function TCategory.FindBBSID(BBSID: string): TBoard;
var
	i: integer;
begin
	Result := nil;
	for i := 0 to Count - 1 do begin
		if Items[i].FBBSID = BBSID then begin
			Result := Items[i];
			Exit;
		end;
	end;
end;

function TCategory.FindBoardFromTitle(Title: string): TBoard;
var
	i: integer;
begin
	Result := nil;
	for i := 0 to Count - 1 do begin
		if Items[i].FTitle = Title then begin
			Result := Items[i];
			Exit;
		end;
	end;
end;

function TCategory.IsMidoku: Boolean;
var
	i: Integer;
	j: Integer;
begin
	Result := False;
	for i := 0 to Count - 1 do begin
		if Items[i] <> nil then begin
			for j := 0 to Items[i].Count - 1 do begin
				if Items[i].Items[j] <> nil then begin
//					if (Items[i].Items[j].IsLogFile) and (Items[i].Items[j].Count > Items[i].Items[j].Kokomade) then begin
					if (Items[i].Items[j].IsLogFile) and (Items[i].Items[j].UnRead) then begin
						Result := True;
						Exit;
					end;
				end;
			end;
		end;
	end;
end;

{class function TCategory.GetColumnName(Index: Integer): string;
begin
	Result := COLUMN_BOARD[Index];
end;

class function TCategory.GetColumnCount: Integer;
begin
	Result := Length(COLUMN_BOARD);
end;}

//===================
//TBoard
//===================
constructor TBoard.Create;
begin
	FNo := 0;
	FTitle := '';
	FBBSID := '';
	FURL := '';
	FRound := False;
	FRoundDate := ZERO_DATE;
	FLastModified := ZERO_DATE;
	FLastGetTime := ZERO_DATE;
	FIsThreadDatRead := False;
	FUnRead := 0;
//	FListStyle := vsReport;
//	FItemNoVisible := True;

	FUpdate := True;
end;

destructor TBoard.Destroy;
begin
	if FModified then begin
		GikoSys.WriteThreadDat(Self);
		SaveSettings;
	end;

	Clear;
	inherited;
end;

function TBoard.GetThreadItem(index: integer): TThreadItem;
begin
	Result := TThreadItem(inherited Items[index]);
end;

procedure TBoard.SetThreadItem(index: integer; value: TThreadItem);
begin
	inherited Items[index] := value;
end;

function TBoard.Add(Item: TThreadItem): Integer;
begin
	Item.ParentBoard := Self;
	Result := inherited Add(Item);
end;

procedure TBoard.Insert(Index: Integer; Item: TThreadItem);
begin
	Item.ParentBoard := Self;
	inherited Insert(Index, Item);
end;

//IndexŎw肳ꂽXbhIuWFNgj
procedure TBoard.Delete(index: Integer);
begin
	if Items[index] <> nil then
		TThreadItem(Items[index]).Free;
	Items[index] := nil;
	inherited Delete(index);
end;

//IndexŎw肳ꂽXbhXg폜iXIuWFNg͂̂j
procedure TBoard.DeleteList(index: integer);
begin
	inherited Delete(index);
end;

procedure TBoard.Clear;
var
	i: integer;
begin
//	FUnRead := 0;
	for i := Count - 1 downto 0 do
		Delete(i);
end;

function TBoard.Find(ItemFileName: string): TThreadItem;
var
	i: integer;
begin
	Result := nil;
	for i := 0 to Count - 1 do begin
		if Items[i].FileName = ItemFileName then begin
			Result := Items[i];
			Exit;
		end;
	end;
end;

function TBoard.GetIndex(ItemFileName: string): Integer;
var
	i: integer;
begin
	Result := -1;
	for i := 0 to Count - 1 do begin
		if Items[i].FileName = ItemFileName then begin
			Result := i;
			Exit;
		end;
	end;
end;

{function TBoard.GetMidokuCount: Integer;
var
	i: integer;
begin
	Result := 0;
	for i := 0 to Count- 1 do begin
		if Items[i] <> nil then begin
			if (Items[i].IsLogFile) and (Items[i].Count > Items[i].Kokomade) then
				inc(Result);
		end;
	end;
end;
}

procedure TBoard.LoadSettings;
var
	ini: TMemIniFile;
	FileName: string;
begin
	FileName := ParentCategory.ParentBBS2ch.GetLogFolder
						+ BBSID + PATH_DELIM + FOLDER_INI_FILENAME;

	if not FileExists(FileName) then
		Exit;
	ini := TMemIniFile.Create(FileName);
	try
//		Round := ini.ReadBool('Status', 'Round', False);
		FRoundDate := ini.ReadDateTime('Status', 'RoundDate', ZERO_DATE);
		FLastModified := ini.ReadDateTime('Status', 'LastModified', ZERO_DATE);
		FLastGetTime := ini.ReadDateTime('Status', 'LastGetTime', ZERO_DATE);
		FUnRead := ini.ReadInteger('Status', 'UnRead', 0);
		FSPID := ini.ReadString('Cookie', 'SPID', '');
		FPON := ini.ReadString('Cookie', 'PON', '');
		FKotehanName := ini.ReadString('Kotehan', 'Name', '');
		FKotehanMail := ini.ReadString('Kotehan', 'Mail', '');
//		ListStyle := TViewStyle(Ord(ini.ReadInteger('Status', 'ListStyle', 3)));
//		ItemNoVisible := ini.ReadBool('Status', 'ItemNoVisible', True);
//		ViewType := TGikoViewType(Ord(ini.ReadInteger('Status', 'ViewType', 0)));
		if UnRead < 0 then
			UnRead := 0;
	finally
		ini.Free;
	end;
end;

procedure TBoard.SaveSettings;
var
	ini: TMemIniFile;
	FileName: string;
begin
	FileName := ParentCategory.ParentBBS2ch.GetLogFolder
						+ BBSID + PATH_DELIM;
	if not GikoSys.DirectoryExistsEx(FileName) then
		GikoSys.ForceDirectoriesEx(FileName);
	FileName := FileName + FOLDER_INI_FILENAME;
	ini := TMemIniFile.Create(FileName);
	try
		if UnRead < 0 then
			UnRead := 0;
//		ini.WriteBool('Status', 'Round', Round);
		ini.WriteDateTime('Status', 'RoundDate', FRoundDate);
		ini.WriteDateTime('Status', 'LastModified', FLastModified);
		ini.WriteDateTime('Status', 'LastGetTime', FLastGetTime);
		ini.WriteInteger('Status', 'UnRead', FUnRead);
		ini.WriteString('Cookie', 'SPID', FSPID);
		ini.WriteString('Cookie', 'PON', FPON);
		ini.WriteString('Kotehan', 'Name', FKotehanName);
		ini.WriteString('Kotehan', 'Mail', FKotehanMail);
//		ini.WriteInteger('Status', 'ListStyle', Ord(ListStyle));
//		ini.WriteBool('Status', 'ItemNoVisible', ItemNoVisible);
//		ini.WriteInteger('Status', 'ViewType', Ord(ViewType));
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

// TuWFNgURL擾
function TBoard.GetReadCgiURL: string;
begin
	//Result := URL + SUBJECT_FILENAME;
	//Result := GikoSys.UrlToServer(URL)
	//				+ 'test/read.cgi/' + BBSID + '/?raw=0.0';
	Result := URL + SUBJECT_FILENAME;

end;

// TuWFNgt@C擾ipX{t@Cj
function TBoard.GetSubjectFileName: string;
begin
	Result := ParentCategory.ParentBBS2ch.GetLogFolder
					+ BBSID + PATH_DELIM + SUBJECT_FILENAME;
end;

// CfbNXt@C(folder.idx)擾ipX{t@Cj
function TBoard.GetFolderIndexFileName: string;
begin
	Result := ParentCategory.ParentBBS2ch.GetLogFolder
					+ BBSID + PATH_DELIM + FOLDER_INDEX_FILENAME;
end;

// XđMURL
function TBoard.GetSendURL: string;
begin
	Result := GikoSys.UrlToServer(URL) + 'test/subbbs.cgi';
end;

procedure TBoard.SetRound(b: Boolean);
begin
	if b then
		RoundList.Add(Self)
	else
		RoundList.Delete(Self);
	if FRound = b then Exit;
	FRound := b;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetRoundName(s: string);
begin
	if FRoundName = s then Exit;
	FRoundName := s;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetLastModified(d: TDateTime);
begin
	if FLastModified = d then Exit;
	FLastModified := d;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetLastGetTime(d: TDateTime);
begin
	if FLastGetTime = d then Exit;
	FLastGetTime := d;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetUnRead(i: Integer);
begin
	if FUnRead = i then Exit;
	if i < 0 then i := 0;
	FUnRead := i;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetKotehanName(s: string);
begin
	if FKotehanName = s then Exit;
	FKotehanName := s;
	if FUpdate then
		FModified := True;
end;

procedure TBoard.SetKotehanMail(s: string);
begin
	if FKotehanMail = s then Exit;
	FKotehanMail := s;
	if FUpdate then
		FModified := True;
end;

function TBoard.GetNewThreadCount: Integer;
var
	i: Integer;
begin
	Result := 0;
        if Length( ParentCategory.ParentBBS2ch.ShortSelectText ) = 0 then
        begin
        	for i := 0 to Count - 1 do begin
        		if Items[i].NewArrival then
        			inc(Result);
        	end;
        end else begin
        	for i := 0 to Count - 1 do begin
                        if Items[i].NewArrival then
                        begin
                                if Items[i].ShortTitle = '' then
                			Items[i].ShortTitle := GikoSys.ZenToHan(Items[i].Title);
                                if AnsiPos(ParentCategory.ParentBBS2ch.ShortSelectText, Items[i].ShortTitle) <> 0 then
                                        inc(Result);
                        end;
        	end;
        end;
end;

function TBoard.GetLogThreadCount: Integer;
var
	i: Integer;
begin
	Result := 0;
        if Length( ParentCategory.ParentBBS2ch.ShortSelectText ) = 0 then
        begin
        	for i := 0 to Count - 1 do begin
        		if Items[i].IsLogFile then
        			inc(Result);
        	end;
        end else begin
        	for i := 0 to Count - 1 do begin
        		if Items[i].IsLogFile then
                        begin
                                if Items[i].ShortTitle = '' then
                			Items[i].ShortTitle := GikoSys.ZenToHan(Items[i].Title);
                                if AnsiPos(ParentCategory.ParentBBS2ch.ShortSelectText, Items[i].ShortTitle) <> 0 then
                                        inc(Result);
                        end;
        	end;
        end;
end;

function TBoard.GetUserThreadCount: Integer;
var
	i: Integer;
begin
	Result := 0;
        if Length( ParentCategory.ParentBBS2ch.ShortSelectText ) = 0 then
                Result := Count
        else
	for i := 0 to Count - 1 do begin
		if Items[i].ShortTitle = '' then
			Items[i].ShortTitle := GikoSys.ZenToHan(Items[i].Title);
		if AnsiPos(ParentCategory.ParentBBS2ch.ShortSelectText, Items[i].ShortTitle) <> 0 then
			inc(Result);
	end;
end;

function TBoard.GetNewThread(Index: Integer): TThreadItem;
var
	i: Integer;
	Cnt: Integer;
begin
	Result := nil;
	Cnt := 0;
        if Length( ParentCategory.ParentBBS2ch.ShortSelectText ) = 0 then
        begin
        	for i := 0 to Count - 1 do begin
        		if Items[i].NewArrival then
                        begin
        			if Index = Cnt then begin
        				Result := Items[i];
        				Exit;
	        		end;
		        	inc(Cnt);
		        end;
 	        end;
        end else begin
	        for i := 0 to Count - 1 do begin
		        if Items[i].NewArrival then
                        begin
		                if Items[i].ShortTitle = '' then
		        	        Items[i].ShortTitle := GikoSys.ZenToHan(Items[i].Title);
		                if AnsiPos(ParentCategory.ParentBBS2ch.ShortSelectText, Items[i].ShortTitle) <> 0 then begin
		        	        if Index = Cnt then begin
		        		        Result := Items[i];
		        		        Exit;
	        		        end;
		        	        inc(Cnt);
                                end;
                        end;
	        end;
        end;
end;

function TBoard.GetLogThread(Index: Integer): TThreadItem;
var
	i: Integer;
	Cnt: Integer;
begin
        if Length( ParentCategory.ParentBBS2ch.ShortSelectText ) = 0 then
        begin
        	for i := 0 to Count - 1 do begin
        		if Items[i].IsLogFile then
                        begin
        			if Index = Cnt then begin
        				Result := Items[i];
        				Exit;
	        		end;
		        	inc(Cnt);
		        end;
 	        end;
        end else begin
	        for i := 0 to Count - 1 do begin
        		if Items[i].IsLogFile then
                        begin
		                if Items[i].ShortTitle = '' then
		        	        Items[i].ShortTitle := GikoSys.ZenToHan(Items[i].Title);
		                if AnsiPos(ParentCategory.ParentBBS2ch.ShortSelectText, Items[i].ShortTitle) <> 0 then begin
		        	        if Index = Cnt then begin
		        		        Result := Items[i];
		        		        Exit;
	        		        end;
		        	        inc(Cnt);
                                end;
                        end;
	        end;
        end;
end;

function TBoard.GetUserThread(Index: Integer): TThreadItem;
var
	i: Integer;
	Cnt: Integer;
begin
	Result := nil;
	Cnt := 0;
        if Length( ParentCategory.ParentBBS2ch.ShortSelectText ) = 0 then
        begin
                for i := 0 to Count - 1 do begin
                        if Index = Cnt then
                        begin
                                Result := Items[ i ];
                                Exit;
                        end;
                        inc( Cnt );
                end;
        end else begin
	        for i := 0 to Count - 1 do begin
	        	if Items[i].ShortTitle = '' then
	        		Items[i].ShortTitle := GikoSys.ZenToHan(Items[i].Title);
        		if AnsiPos(ParentCategory.ParentBBS2ch.ShortSelectText, Items[i].ShortTitle) <> 0 then begin
        			if Index = Cnt then begin
        				Result := Items[i];
	        			Exit;
	        		end;
	        		inc(Cnt);
	        	end;
	        end;
        end;
end;

procedure TBoard.BeginUpdate;
begin
	FUpdate := False;
end;

procedure TBoard.EndUpdate;
begin
	FUpdate := True;
end;

{class function TBoard.GetColumnName(Index: Integer): string;
begin
	Result := COLUMN_THREADITEM[Index];
end;

class function TBoard.GetColumnCount: Integer;
begin
	Result := Length(COLUMN_THREADITEM);
end;}

//constructor TThreadItem.Create(AOwner: TComponent);
constructor TThreadItem.Create;
begin
	FNo := 0;
	FFileName := '';
	FTitle := '';
	FRoundDate := ZERO_DATE;
	FLastModified := ZERO_DATE;
	FCount := 0;
	FAllResCount := 0;
	FNewResCount := 0;
	FSize := 0;
	FRound := False;
	FIsLogFile := False;
	FParentBoard := nil;
	FKokomade := -1;
	FNewReceive := 0;
	FNewArrival := False;

	FUpdate := True;
end;

destructor TThreadItem.Destroy;
begin
	inherited;
end;

function TThreadItem.GetDatURL: string;
var
	Protocol, Host, Path, Document, Port, Bookmark: string;
begin
	Result := ParentBoard.URL
					+ 'dat/'
					+ FileName;
	if FDownloadHost <> '' then begin
		GikoSys.ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		Result := Format('%s://%s%s%s', [Protocol,
																		 FDownloadHost,
																		 Path,
																		 Document]);
	end;
//	Result := GikoSys.UrlToServer(ParentBoard.URL)
//					+ 'test/read.cgi/' + ParentBoard.BBSID + '/'
//					+ ChangeFileExt(FileName, '') + '/?raw='
//					+ IntToStr(ResNum) + '.' + IntToStr(ResSize);
end;

function TThreadItem.GetDatgzURL: string;
	function isOldKako(s: string): Boolean;
	begin
		Result := False;
		if AnsiPos('piza.', s) <> 0 then
			Result := True
		else if AnsiPos('www.bbspink.', s) <> 0 then
			Result := True
		else if AnsiPos('tako.', s) <> 0 then
			Result := True;
	end;
var
	Protocol, Host, Path, Document, Port, Bookmark: string;
	DatNo: string;
begin
	if FDownloadHost = '' then begin
		DatNo := ChangeFileExt(FileName, '');
		if isOldKako(ParentBoard.URL) then begin
			Result := Format('%s%s/%.3s/%s.dat', [ParentBoard.URL, 'kako', DatNo, DatNo]);
		end else begin
			if Length(DatNo) > 9 then begin
				//http://xxx.2ch.net/xxx/kako/9999/99999/999999999.dat.gz
				Result := Format('%s%s/%.4s/%.5s/%s.dat.gz', [ParentBoard.URL, 'kako', DatNo, DatNo, DatNo]);
			end else begin
				//http://xxx.2ch.net/xxx/kako/999/999999999.dat.gz
				Result := Format('%s%s/%.3s/%s.dat.gz', [ParentBoard.URL, 'kako', DatNo, DatNo]);
			end;
		end;
	end else begin
		Gikosys.ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		DatNo := ChangeFileExt(Document, '');
		if isOldKako(DownloadHost) then begin
			Result := Format('%s://%s/%s/kako/%.3s/%s.dat', [Protocol, DownloadHost, ParentBoard.FBBSID, DatNo, DatNo]);
		end else begin
			if Length(DatNo) > 9 then begin
				Result := Format('%s://%s/%s/kako/%.4s/%.5s/%s.dat.gz', [Protocol, DownloadHost, ParentBoard.FBBSID, DatNo, DatNo, DatNo]);
			end else begin
				Result := Format('%s://%s/%s/kako/%.3s/%s.dat.gz', [Protocol, DownloadHost, ParentBoard.FBBSID, DatNo, DatNo]);
			end;
		end;
	end;
end;

{function TThreadItem.GetOldDatgzURL: string;
var
	Protocol, Host, Path, Document, Port, Bookmark: string;
begin
	Result := Format('%s%s/%.3s/%s.gz', [ParentBoard.URL,
																			 'kako',
																			 FileName,
																			 FileName]);
	if FDownloadHost <> '' then begin
		ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		Result := Format('%s://%s%s%s', [Protocol,
																		 DownloadHost,
																		 Path,
																		 Document]);

	end;
end;}

function TThreadItem.GetOfflawCgiURL(SessionID: string): string;
//var
//	Protocol, Host, Path, Document, Port, Bookmark: string;
begin
//	Result := GikoSys.UrlToServer(ParentBoard.URL)
//					+ 'test/offlaw.cgi/' + ParentBoard.BBSID + '/'
//					+ ChangeFileExt(FileName, '') + '/?raw=.0&sid=' + HttpEncode(SessionID);
	if FDownloadHost = '' then begin
		Result := GikoSys.UrlToServer(ParentBoard.URL)
						+ 'test/offlaw.cgi/' + ParentBoard.BBSID + '/'
						+ ChangeFileExt(FileName, '') + '/?raw=.0&sid=' + HttpEncode(SessionID);
	end else begin
		//http://news.2ch.net/test/offlaw.cgi/newsplus/1014038577/?raw=.196928&sid=
		//GikoSys.ParseURI(Result, Protocol, Host, Path, Document, Port, Bookmark);
		Result := 'http://' + FDownloadHost
						+ '/test/offlaw.cgi/' + ParentBoard.BBSID + '/'
						+ ChangeFileExt(FileName, '') + '/?raw=.0&sid=' + HttpEncode(SessionID);
//		Result := Format('%s://%s%s%s', [Protocol,
//																		 DownloadHost,
//																		 Path,
//																		 Document]);
	end;
end;

function TThreadItem.GetSendURL: string;
begin
	Result := GikoSys.UrlToServer(ParentBoard.URL)
					+ 'test/bbs.cgi';
end;

procedure TThreadItem.DeleteLogFile;
begin
	DeleteFile(GetThreadFileName);

	FRoundDate := ZERO_DATE;
	FLastModified := ZERO_DATE;
	FSize := 0;
	FIsLogFile := False;
	FKokomade := -1;
	FNewReceive := 0;
	FNewArrival := False;
	FUnRead := False;
	FScrollTop := 0;
	FRound := False;
	FDownloadHost := '';
	FAgeSage := gasNone;

	FCount := 0;
	FNewResCount := 0;
	FRoundName := '';
end;

function TThreadItem.GetThreadFileName: string;
begin
	Result := ParentBoard.ParentCategory.ParentBBS2ch.GetLogFolder
					+ ParentBoard.BBSID + PATH_DELIM + FileName;
end;

procedure TThreadItem.SetLastModified(d: TDateTime);
begin
	if FLastModified = d then Exit;
	FLastModified := d;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

{procedure TThreadItem.SetRoundNo(i: Integer);
begin
	if FRoundNo = i then Exit;
	FRoundNo := i;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;}

procedure TThreadItem.SetRound(b: Boolean);
begin
	if b then
		RoundList.Add(Self)
	else
		RoundList.Delete(Self);
	if FRound = b then Exit;
	FRound := b;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetRoundName(s: string);
begin
	if FRoundName = s then Exit;
	FRoundName := s;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetKokomade(i: Integer);
begin
	if FKokomade = i then Exit;
	FKokomade := i;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetUnRead(b: Boolean);
begin
	if FUnRead = b then Exit;
	FUnRead := b;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.SetScrollTop(i: Integer);
begin
	if FScrollTop = i then Exit;
	FScrollTop := i;
	if FUpdate and (ParentBoard <> nil) then
		ParentBoard.FModified := True;
end;

procedure TThreadItem.BeginUpdate;
begin
	FUpdate := False;
end;

procedure TThreadItem.EndUpdate;
begin
	FUpdate := True;
end;

{initialization
	BBS2ch := TBBS2ch.Create;

finalization
	if BBS2ch <> nil then
		BBS2ch.Free;}
end.

